/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import java.util.LinkedList;
import java.util.List;

public class StringUtills {
    public static String expandTabs(String str) {
        return str.replace("\t", "    ");
    }

    public static String htmlEntites(String str) {
        return str.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String normalize(String str) {
        return StringUtills.expandTabs(StringUtills.htmlEntites(str));
    }

    public static List<String> normalize(List<String> list) {
        LinkedList<String> result = new LinkedList<String>();
        for (String line : list) {
            result.add(StringUtills.normalize(line));
        }
        return result;
    }

    public static List<String> wrapText(List<String> list, int columnWidth) {
        LinkedList<String> result = new LinkedList<String>();
        for (String line : list) {
            result.add(StringUtills.wrapText(line, columnWidth));
        }
        return result;
    }

    public static String wrapText(String line, int columnWidth) {
        int lenght = line.length();
        int delimiter = "<br>".length();
        int widthIndex = columnWidth;
        int count = 0;
        while (lenght > widthIndex) {
            line = line.subSequence(0, widthIndex + delimiter * count) + "<br>" + line.substring(widthIndex + delimiter * count);
            widthIndex += columnWidth;
            ++count;
        }
        return line;
    }
}

