/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Optional;
import java.util.function.Predicate;
import jp.skypencil.errorprone.slf4j.Consts;

@BugPattern(name="Slf4jDoNotLogMessageOfExceptionExplicitly", summary="Do not log message returned from Throwable#getMessage and Throwable#getLocalizedMessage", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.ERROR)
public class ManuallyProvidedMessage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 7903613628689308557L;
    private static final Predicate<String> MESSAGE_GETTER = "getMessage"::equals;
    private static final Predicate<String> LOCALIZED_MESSAGE_GETTER = "getLocalizedMessage"::equals;
    private static final Predicate<String> THROWABLE = "java.lang.Throwable"::equals;

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol method = ASTHelpers.getSymbol((Tree)tree.getMethodSelect());
        String methodStr = method.toString();
        String methodName = methodStr.substring(0, methodStr.indexOf(40));
        if (!Consts.TARGET_METHOD_NAMES.contains((Object)methodName)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol clazz = method.enclClass();
        if (!"org.slf4j.Logger".equals(((Symbol)clazz).toString())) {
            return Description.NO_MATCH;
        }
        Optional<JCTree.JCFieldAccess> problem = tree.getArguments().stream().filter(arg -> arg.getClass().isAssignableFrom(JCTree.JCMethodInvocation.class)).map(JCTree.JCMethodInvocation.class::cast).map(arg -> arg.meth).filter(meth -> meth.getClass().isAssignableFrom(JCTree.JCFieldAccess.class)).map(JCTree.JCFieldAccess.class::cast).filter(meth -> MESSAGE_GETTER.or(LOCALIZED_MESSAGE_GETTER).test(meth.sym.name.toString())).filter(meth -> THROWABLE.test(meth.sym.owner.toString())).findFirst();
        if (problem.isPresent()) {
            return Description.builder((Tree)tree, (String)"Slf4jDoNotLogMessageOfExceptionExplicitly", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_manually_provided_message", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.ERROR, (String)"Do not log message returned from Throwable#getMessage and Throwable#getLocalizedMessage. It is enough to provide throwable instance as the last argument, then binding will log its message.").build();
        }
        return Description.NO_MATCH;
    }
}

