/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import jp.skypencil.errorprone.slf4j.Consts;

@BugPattern(name="Slf4jFormatShouldBeConst", summary="Format of SLF4J logging should be constant value", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.ERROR)
public class FormatShouldBeConst
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 3271269614137732880L;
    private static final CompileTimeConstantExpressionMatcher IS_CONST = new CompileTimeConstantExpressionMatcher();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        int formatIndex;
        if (!Consts.IS_LOGGING_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        java.util.List parameters = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
        int n = formatIndex = ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)((List)parameters).get((int)0)).type, (Type)state.getTypeFromString("org.slf4j.Marker"), (VisitorState)state) ? 1 : 0;
        if (IS_CONST.matches(tree.getArguments().get(formatIndex), state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("SLF4J logging format should be constant value, but it is '%s'", tree.getArguments().get(formatIndex));
        return Description.builder((Tree)tree, (String)"Slf4jFormatShouldBeConst", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_format_should_be_const", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.ERROR, (String)message).build();
    }
}

