/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v5.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v5.model.FeedItemServiceApprovalStatus;
import jp.co.yahoo.adssearchapi.v5.model.FeedItemServicePlaceholderType;

@ApiModel(description="<div lang=\"ja\">FeedItemServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u30d5\u30a3\u30fc\u30c9\u30a2\u30a4\u30c6\u30e0\u306e\u60c5\u5831\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002</div> <div lang=\"en\">FeedItemServiceSelector describes the Feed item information.</div> ")
public class FeedItemServiceSelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="approvalStatuses")
    @Valid
    private List<FeedItemServiceApprovalStatus> approvalStatuses = null;
    @JsonProperty(value="feedIds")
    @Valid
    private List<Long> feedIds = null;
    @JsonProperty(value="feedItemIds")
    @Valid
    private List<Long> feedItemIds = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="placeholderTypes")
    @Valid
    private List<FeedItemServicePlaceholderType> placeholderTypes = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public FeedItemServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Search condition: Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public FeedItemServiceSelector approvalStatuses(List<FeedItemServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
        return this;
    }

    public FeedItemServiceSelector addApprovalStatusesItem(FeedItemServiceApprovalStatus approvalStatusesItem) {
        if (this.approvalStatuses == null) {
            this.approvalStatuses = new ArrayList<FeedItemServiceApprovalStatus>();
        }
        this.approvalStatuses.add(approvalStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<FeedItemServiceApprovalStatus> getApprovalStatuses() {
        return this.approvalStatuses;
    }

    public void setApprovalStatuses(List<FeedItemServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
    }

    public FeedItemServiceSelector feedIds(List<Long> feedIds) {
        this.feedIds = feedIds;
        return this;
    }

    public FeedItemServiceSelector addFeedIdsItem(Long feedIdsItem) {
        if (this.feedIds == null) {
            this.feedIds = new ArrayList<Long>();
        }
        this.feedIds.add(feedIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30d5\u30a3\u30fc\u30c9ID\u3067\u3059\u3002</div> <div lang=\"en\">Search condition: Feed ID.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getFeedIds() {
        return this.feedIds;
    }

    public void setFeedIds(List<Long> feedIds) {
        this.feedIds = feedIds;
    }

    public FeedItemServiceSelector feedItemIds(List<Long> feedItemIds) {
        this.feedItemIds = feedItemIds;
        return this;
    }

    public FeedItemServiceSelector addFeedItemIdsItem(Long feedItemIdsItem) {
        if (this.feedItemIds == null) {
            this.feedItemIds = new ArrayList<Long>();
        }
        this.feedItemIds.add(feedItemIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30d5\u30a3\u30fc\u30c9\u30a2\u30a4\u30c6\u30e0ID\u3067\u3059\u3002</div> <div lang=\"en\">Search condition: Feed Item ID.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getFeedItemIds() {
        return this.feedItemIds;
    }

    public void setFeedItemIds(List<Long> feedItemIds) {
        this.feedItemIds = feedItemIds;
    }

    public FeedItemServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=2000L)
    public @Min(value=1L) @Max(value=2000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public FeedItemServiceSelector placeholderTypes(List<FeedItemServicePlaceholderType> placeholderTypes) {
        this.placeholderTypes = placeholderTypes;
        return this;
    }

    public FeedItemServiceSelector addPlaceholderTypesItem(FeedItemServicePlaceholderType placeholderTypesItem) {
        if (this.placeholderTypes == null) {
            this.placeholderTypes = new ArrayList<FeedItemServicePlaceholderType>();
        }
        this.placeholderTypes.add(placeholderTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<FeedItemServicePlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public void setPlaceholderTypes(List<FeedItemServicePlaceholderType> placeholderTypes) {
        this.placeholderTypes = placeholderTypes;
    }

    public FeedItemServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedItemServiceSelector feedItemServiceSelector = (FeedItemServiceSelector)o;
        return Objects.equals(this.accountId, feedItemServiceSelector.accountId) && Objects.equals(this.approvalStatuses, feedItemServiceSelector.approvalStatuses) && Objects.equals(this.feedIds, feedItemServiceSelector.feedIds) && Objects.equals(this.feedItemIds, feedItemServiceSelector.feedItemIds) && Objects.equals(this.numberResults, feedItemServiceSelector.numberResults) && Objects.equals(this.placeholderTypes, feedItemServiceSelector.placeholderTypes) && Objects.equals(this.startIndex, feedItemServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.approvalStatuses, this.feedIds, this.feedItemIds, this.numberResults, this.placeholderTypes, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeedItemServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    approvalStatuses: ").append(this.toIndentedString(this.approvalStatuses)).append("\n");
        sb.append("    feedIds: ").append(this.toIndentedString(this.feedIds)).append("\n");
        sb.append("    feedItemIds: ").append(this.toIndentedString(this.feedItemIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    placeholderTypes: ").append(this.toIndentedString(this.placeholderTypes)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

