/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v6.model.AssetServiceApprovalStatus;
import jp.co.yahoo.adssearchapi.v6.model.AssetServiceType;

@ApiModel(description="<div lang=\"ja\">AssetServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u30a2\u30bb\u30c3\u30c8\u306e\u60c5\u5831\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002</div> <div lang=\"en\">AssetServiceSelector describes the Asset information.</div> ")
public class AssetServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-search-api-lib:0.0.12";
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="assetIds")
    @Valid
    private List<Long> assetIds = null;
    @JsonProperty(value="types")
    @Valid
    private List<AssetServiceType> types = null;
    @JsonProperty(value="approvalStatuses")
    @Valid
    private List<AssetServiceApprovalStatus> approvalStatuses = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public AssetServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Search condition: Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AssetServiceSelector assetIds(List<Long> assetIds) {
        this.assetIds = assetIds;
        return this;
    }

    public AssetServiceSelector addAssetIdsItem(Long assetIdsItem) {
        if (this.assetIds == null) {
            this.assetIds = new ArrayList<Long>();
        }
        this.assetIds.add(assetIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30bb\u30c3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Search condition: Asset ID.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getAssetIds() {
        return this.assetIds;
    }

    public void setAssetIds(List<Long> assetIds) {
        this.assetIds = assetIds;
    }

    public AssetServiceSelector types(List<AssetServiceType> types) {
        this.types = types;
        return this;
    }

    public AssetServiceSelector addTypesItem(AssetServiceType typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<AssetServiceType>();
        }
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=4)
    public @Valid @Size(max=4) List<AssetServiceType> getTypes() {
        return this.types;
    }

    public void setTypes(List<AssetServiceType> types) {
        this.types = types;
    }

    public AssetServiceSelector approvalStatuses(List<AssetServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
        return this;
    }

    public AssetServiceSelector addApprovalStatusesItem(AssetServiceApprovalStatus approvalStatusesItem) {
        if (this.approvalStatuses == null) {
            this.approvalStatuses = new ArrayList<AssetServiceApprovalStatus>();
        }
        this.approvalStatuses.add(approvalStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<AssetServiceApprovalStatus> getApprovalStatuses() {
        return this.approvalStatuses;
    }

    public void setApprovalStatuses(List<AssetServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
    }

    public AssetServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=2000L)
    public @Min(value=1L) @Max(value=2000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AssetServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetServiceSelector assetServiceSelector = (AssetServiceSelector)o;
        return Objects.equals(this.accountId, assetServiceSelector.accountId) && Objects.equals(this.assetIds, assetServiceSelector.assetIds) && Objects.equals(this.types, assetServiceSelector.types) && Objects.equals(this.approvalStatuses, assetServiceSelector.approvalStatuses) && Objects.equals(this.numberResults, assetServiceSelector.numberResults) && Objects.equals(this.startIndex, assetServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.assetIds, this.types, this.approvalStatuses, this.numberResults, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    assetIds: ").append(this.toIndentedString(this.assetIds)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    approvalStatuses: ").append(this.toIndentedString(this.approvalStatuses)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

