/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v5.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v5.model.CampaignTargetServiceExcludedType;
import jp.co.yahoo.adssearchapi.v5.model.CampaignTargetServicePlatformType;
import jp.co.yahoo.adssearchapi.v5.model.CampaignTargetServiceTargetType;

@ApiModel(description="<div lang=\"ja\">CampaignTargetServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u64cd\u4f5c\u306e\u5bfe\u8c61\u3068\u3059\u308b\u30ad\u30e3\u30f3\u30da\u30fc\u30f3\u306e\u30bf\u30fc\u30b2\u30c6\u30a3\u30f3\u30b0\u8a2d\u5b9a\u3092\u8868\u3057\u307e\u3059\u3002</div> <div lang=\"en\">CampaignTargetSelector object describes the targeting settings on the campaign to be operated.</div> ")
public class CampaignTargetServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-search-api-lib:0.0.11";
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="campaignIds")
    @Valid
    private List<Long> campaignIds = null;
    @JsonProperty(value="excludedType")
    private CampaignTargetServiceExcludedType excludedType = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="platformTypes")
    @Valid
    private List<CampaignTargetServicePlatformType> platformTypes = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;
    @JsonProperty(value="targetIds")
    @Valid
    private List<String> targetIds = null;
    @JsonProperty(value="targetTypes")
    @Valid
    private List<CampaignTargetServiceTargetType> targetTypes = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public CampaignTargetServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public CampaignTargetServiceSelector campaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public CampaignTargetServiceSelector addCampaignIdsItem(Long campaignIdsItem) {
        if (this.campaignIds == null) {
            this.campaignIds = new ArrayList<Long>();
        }
        this.campaignIds.add(campaignIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30ad\u30e3\u30f3\u30da\u30fc\u30f3ID\u3067\u3059\u3002</div> <div lang=\"en\">Campaign ID.</div> ")
    @Size(max=500)
    public @Size(max=500) List<Long> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public CampaignTargetServiceSelector excludedType(CampaignTargetServiceExcludedType excludedType) {
        this.excludedType = excludedType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public CampaignTargetServiceExcludedType getExcludedType() {
        return this.excludedType;
    }

    public void setExcludedType(CampaignTargetServiceExcludedType excludedType) {
        this.excludedType = excludedType;
    }

    public CampaignTargetServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=500L)
    public @Min(value=1L) @Max(value=500L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public CampaignTargetServiceSelector platformTypes(List<CampaignTargetServicePlatformType> platformTypes) {
        this.platformTypes = platformTypes;
        return this;
    }

    public CampaignTargetServiceSelector addPlatformTypesItem(CampaignTargetServicePlatformType platformTypesItem) {
        if (this.platformTypes == null) {
            this.platformTypes = new ArrayList<CampaignTargetServicePlatformType>();
        }
        this.platformTypes.add(platformTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=3)
    public @Valid @Size(max=3) List<CampaignTargetServicePlatformType> getPlatformTypes() {
        return this.platformTypes;
    }

    public void setPlatformTypes(List<CampaignTargetServicePlatformType> platformTypes) {
        this.platformTypes = platformTypes;
    }

    public CampaignTargetServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public CampaignTargetServiceSelector targetIds(List<String> targetIds) {
        this.targetIds = targetIds;
        return this;
    }

    public CampaignTargetServiceSelector addTargetIdsItem(String targetIdsItem) {
        if (this.targetIds == null) {
            this.targetIds = new ArrayList<String>();
        }
        this.targetIds.add(targetIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30bf\u30fc\u30b2\u30c3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Target ID.</div> ")
    @Size(max=500)
    public @Size(max=500) List<String> getTargetIds() {
        return this.targetIds;
    }

    public void setTargetIds(List<String> targetIds) {
        this.targetIds = targetIds;
    }

    public CampaignTargetServiceSelector targetTypes(List<CampaignTargetServiceTargetType> targetTypes) {
        this.targetTypes = targetTypes;
        return this;
    }

    public CampaignTargetServiceSelector addTargetTypesItem(CampaignTargetServiceTargetType targetTypesItem) {
        if (this.targetTypes == null) {
            this.targetTypes = new ArrayList<CampaignTargetServiceTargetType>();
        }
        this.targetTypes.add(targetTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=4)
    public @Valid @Size(max=4) List<CampaignTargetServiceTargetType> getTargetTypes() {
        return this.targetTypes;
    }

    public void setTargetTypes(List<CampaignTargetServiceTargetType> targetTypes) {
        this.targetTypes = targetTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignTargetServiceSelector campaignTargetServiceSelector = (CampaignTargetServiceSelector)o;
        return Objects.equals(this.accountId, campaignTargetServiceSelector.accountId) && Objects.equals(this.campaignIds, campaignTargetServiceSelector.campaignIds) && Objects.equals((Object)this.excludedType, (Object)campaignTargetServiceSelector.excludedType) && Objects.equals(this.numberResults, campaignTargetServiceSelector.numberResults) && Objects.equals(this.platformTypes, campaignTargetServiceSelector.platformTypes) && Objects.equals(this.startIndex, campaignTargetServiceSelector.startIndex) && Objects.equals(this.targetIds, campaignTargetServiceSelector.targetIds) && Objects.equals(this.targetTypes, campaignTargetServiceSelector.targetTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.campaignIds, this.excludedType, this.numberResults, this.platformTypes, this.startIndex, this.targetIds, this.targetTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignTargetServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    campaignIds: ").append(this.toIndentedString(this.campaignIds)).append("\n");
        sb.append("    excludedType: ").append(this.toIndentedString((Object)this.excludedType)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    platformTypes: ").append(this.toIndentedString(this.platformTypes)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    targetIds: ").append(this.toIndentedString(this.targetIds)).append("\n");
        sb.append("    targetTypes: ").append(this.toIndentedString(this.targetTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

