/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v4.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v4.model.PageFeedItemServiceApprovalStatus;
import jp.co.yahoo.adssearchapi.v4.model.PageFeedItemServicePageFeedUrl;

@ApiModel(description="<div lang=\"ja\">PageFeedItemServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u767b\u9332\u3057\u305f\u30da\u30fc\u30b8\u30d5\u30a3\u30fc\u30c9\u30a2\u30a4\u30c6\u30e0\u3092\u7167\u4f1a\u3059\u308b\u305f\u3081\u306e\u691c\u7d22\u6761\u4ef6\u3092\u683c\u7d0d\u3057\u307e\u3059\u3002</div> <div lang=\"en\">PageFeedItemServiceSelector object stores search condition to inquire about registered page feed item.</div> ")
public class PageFeedItemServiceSelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="approvalStatuses")
    @Valid
    private List<PageFeedItemServiceApprovalStatus> approvalStatuses = null;
    @JsonProperty(value="feedIds")
    @Valid
    private List<Long> feedIds = new ArrayList<Long>();
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="pageFeedCustomLabel")
    @Valid
    private List<String> pageFeedCustomLabel = null;
    @JsonProperty(value="pageFeedUrl")
    @Valid
    private List<PageFeedItemServicePageFeedUrl> pageFeedUrl = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public PageFeedItemServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Account ID</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public PageFeedItemServiceSelector approvalStatuses(List<PageFeedItemServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
        return this;
    }

    public PageFeedItemServiceSelector addApprovalStatusesItem(PageFeedItemServiceApprovalStatus approvalStatusesItem) {
        if (this.approvalStatuses == null) {
            this.approvalStatuses = new ArrayList<PageFeedItemServiceApprovalStatus>();
        }
        this.approvalStatuses.add(approvalStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<PageFeedItemServiceApprovalStatus> getApprovalStatuses() {
        return this.approvalStatuses;
    }

    public void setApprovalStatuses(List<PageFeedItemServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
    }

    public PageFeedItemServiceSelector feedIds(List<Long> feedIds) {
        this.feedIds = feedIds;
        return this;
    }

    public PageFeedItemServiceSelector addFeedIdsItem(Long feedIdsItem) {
        if (this.feedIds == null) {
            this.feedIds = new ArrayList<Long>();
        }
        this.feedIds.add(feedIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30d5\u30a3\u30fc\u30c9ID</div> <div lang=\"en\">Feed ID</div> ")
    @NotNull
    @Size(min=1, max=1000)
    public @NotNull @Size(min=1, max=1000) List<Long> getFeedIds() {
        return this.feedIds;
    }

    public void setFeedIds(List<Long> feedIds) {
        this.feedIds = feedIds;
    }

    public PageFeedItemServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=10000L)
    public @Min(value=1L) @Max(value=10000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public PageFeedItemServiceSelector pageFeedCustomLabel(List<String> pageFeedCustomLabel) {
        this.pageFeedCustomLabel = pageFeedCustomLabel;
        return this;
    }

    public PageFeedItemServiceSelector addPageFeedCustomLabelItem(String pageFeedCustomLabelItem) {
        if (this.pageFeedCustomLabel == null) {
            this.pageFeedCustomLabel = new ArrayList<String>();
        }
        this.pageFeedCustomLabel.add(pageFeedCustomLabelItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30ab\u30b9\u30bf\u30e0\u30e9\u30d9\u30eb</div> <div lang=\"en\">Custom label</div> ")
    @Size(max=5)
    public @Size(max=5) List<String> getPageFeedCustomLabel() {
        return this.pageFeedCustomLabel;
    }

    public void setPageFeedCustomLabel(List<String> pageFeedCustomLabel) {
        this.pageFeedCustomLabel = pageFeedCustomLabel;
    }

    public PageFeedItemServiceSelector pageFeedUrl(List<PageFeedItemServicePageFeedUrl> pageFeedUrl) {
        this.pageFeedUrl = pageFeedUrl;
        return this;
    }

    public PageFeedItemServiceSelector addPageFeedUrlItem(PageFeedItemServicePageFeedUrl pageFeedUrlItem) {
        if (this.pageFeedUrl == null) {
            this.pageFeedUrl = new ArrayList<PageFeedItemServicePageFeedUrl>();
        }
        this.pageFeedUrl.add(pageFeedUrlItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<PageFeedItemServicePageFeedUrl> getPageFeedUrl() {
        return this.pageFeedUrl;
    }

    public void setPageFeedUrl(List<PageFeedItemServicePageFeedUrl> pageFeedUrl) {
        this.pageFeedUrl = pageFeedUrl;
    }

    public PageFeedItemServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageFeedItemServiceSelector pageFeedItemServiceSelector = (PageFeedItemServiceSelector)o;
        return Objects.equals(this.accountId, pageFeedItemServiceSelector.accountId) && Objects.equals(this.approvalStatuses, pageFeedItemServiceSelector.approvalStatuses) && Objects.equals(this.feedIds, pageFeedItemServiceSelector.feedIds) && Objects.equals(this.numberResults, pageFeedItemServiceSelector.numberResults) && Objects.equals(this.pageFeedCustomLabel, pageFeedItemServiceSelector.pageFeedCustomLabel) && Objects.equals(this.pageFeedUrl, pageFeedItemServiceSelector.pageFeedUrl) && Objects.equals(this.startIndex, pageFeedItemServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.approvalStatuses, this.feedIds, this.numberResults, this.pageFeedCustomLabel, this.pageFeedUrl, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageFeedItemServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    approvalStatuses: ").append(this.toIndentedString(this.approvalStatuses)).append("\n");
        sb.append("    feedIds: ").append(this.toIndentedString(this.feedIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    pageFeedCustomLabel: ").append(this.toIndentedString(this.pageFeedCustomLabel)).append("\n");
        sb.append("    pageFeedUrl: ").append(this.toIndentedString(this.pageFeedUrl)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

