/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v4.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v4.model.AuditLogServiceJobStatus;

@ApiModel(description="<div lang=\"ja\">AuditLogServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u767b\u9332\u3057\u305f\u30b8\u30e7\u30d6\u3092\u7167\u4f1a\u3059\u308b\u305f\u3081\u306e\u691c\u7d22\u6761\u4ef6\u3092\u4fdd\u6301\u3057\u307e\u3059\u3002</div> <div lang=\"en\">AuditLogServiceSelector object retains search criterias to inquire a created job.</div> ")
public class AuditLogServiceSelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="jobIds")
    @Valid
    private List<Long> jobIds = null;
    @JsonProperty(value="jobStatuses")
    @Valid
    private List<AuditLogServiceJobStatus> jobStatuses = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public AuditLogServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Account ID</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AuditLogServiceSelector jobIds(List<Long> jobIds) {
        this.jobIds = jobIds;
        return this;
    }

    public AuditLogServiceSelector addJobIdsItem(Long jobIdsItem) {
        if (this.jobIds == null) {
            this.jobIds = new ArrayList<Long>();
        }
        this.jobIds.add(jobIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u767b\u9332\u3057\u305f\u30b8\u30e7\u30d6\u306eID\u3067\u3059\u3002</div> <div lang=\"en\">Created job ID</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getJobIds() {
        return this.jobIds;
    }

    public void setJobIds(List<Long> jobIds) {
        this.jobIds = jobIds;
    }

    public AuditLogServiceSelector jobStatuses(List<AuditLogServiceJobStatus> jobStatuses) {
        this.jobStatuses = jobStatuses;
        return this;
    }

    public AuditLogServiceSelector addJobStatusesItem(AuditLogServiceJobStatus jobStatusesItem) {
        if (this.jobStatuses == null) {
            this.jobStatuses = new ArrayList<AuditLogServiceJobStatus>();
        }
        this.jobStatuses.add(jobStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=4)
    public @Valid @Size(max=4) List<AuditLogServiceJobStatus> getJobStatuses() {
        return this.jobStatuses;
    }

    public void setJobStatuses(List<AuditLogServiceJobStatus> jobStatuses) {
        this.jobStatuses = jobStatuses;
    }

    public AuditLogServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AuditLogServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogServiceSelector auditLogServiceSelector = (AuditLogServiceSelector)o;
        return Objects.equals(this.accountId, auditLogServiceSelector.accountId) && Objects.equals(this.jobIds, auditLogServiceSelector.jobIds) && Objects.equals(this.jobStatuses, auditLogServiceSelector.jobStatuses) && Objects.equals(this.numberResults, auditLogServiceSelector.numberResults) && Objects.equals(this.startIndex, auditLogServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.jobIds, this.jobStatuses, this.numberResults, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    jobIds: ").append(this.toIndentedString(this.jobIds)).append("\n");
        sb.append("    jobStatuses: ").append(this.toIndentedString(this.jobStatuses)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

