/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adsdisplayapi.v6.model.RetargetingListServiceSharingStatusFilterType;
import jp.co.yahoo.adsdisplayapi.v6.model.RetargetingListServiceTargetListType;

@ApiModel(description="<div lang=\"ja\">RetargetingListServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u30b5\u30a4\u30c8\u30ea\u30bf\u30fc\u30b2\u30c6\u30a3\u30f3\u30b0\u306e\u30bf\u30fc\u30b2\u30c3\u30c8\u30ea\u30b9\u30c8\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002</div> <div lang=\"en\">RetargetingListServiceSelector object selects the target list for site retargeting.</div> ")
public class RetargetingListServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-display-api-lib:0.0.11";
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;
    @JsonProperty(value="targetListIds")
    @Valid
    private List<Long> targetListIds = null;
    @JsonProperty(value="targetListTypes")
    @Valid
    private List<RetargetingListServiceTargetListType> targetListTypes = null;
    @JsonProperty(value="sharingStatusFilterType")
    private RetargetingListServiceSharingStatusFilterType sharingStatusFilterType = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public RetargetingListServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public RetargetingListServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public RetargetingListServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public RetargetingListServiceSelector targetListIds(List<Long> targetListIds) {
        this.targetListIds = targetListIds;
        return this;
    }

    public RetargetingListServiceSelector addTargetListIdsItem(Long targetListIdsItem) {
        if (this.targetListIds == null) {
            this.targetListIds = new ArrayList<Long>();
        }
        this.targetListIds.add(targetListIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30bf\u30fc\u30b2\u30c3\u30c8\u30ea\u30b9\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Target List ID.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getTargetListIds() {
        return this.targetListIds;
    }

    public void setTargetListIds(List<Long> targetListIds) {
        this.targetListIds = targetListIds;
    }

    public RetargetingListServiceSelector targetListTypes(List<RetargetingListServiceTargetListType> targetListTypes) {
        this.targetListTypes = targetListTypes;
        return this;
    }

    public RetargetingListServiceSelector addTargetListTypesItem(RetargetingListServiceTargetListType targetListTypesItem) {
        if (this.targetListTypes == null) {
            this.targetListTypes = new ArrayList<RetargetingListServiceTargetListType>();
        }
        this.targetListTypes.add(targetListTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<RetargetingListServiceTargetListType> getTargetListTypes() {
        return this.targetListTypes;
    }

    public void setTargetListTypes(List<RetargetingListServiceTargetListType> targetListTypes) {
        this.targetListTypes = targetListTypes;
    }

    public RetargetingListServiceSelector sharingStatusFilterType(RetargetingListServiceSharingStatusFilterType sharingStatusFilterType) {
        this.sharingStatusFilterType = sharingStatusFilterType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public RetargetingListServiceSharingStatusFilterType getSharingStatusFilterType() {
        return this.sharingStatusFilterType;
    }

    public void setSharingStatusFilterType(RetargetingListServiceSharingStatusFilterType sharingStatusFilterType) {
        this.sharingStatusFilterType = sharingStatusFilterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetargetingListServiceSelector retargetingListServiceSelector = (RetargetingListServiceSelector)o;
        return Objects.equals(this.accountId, retargetingListServiceSelector.accountId) && Objects.equals(this.numberResults, retargetingListServiceSelector.numberResults) && Objects.equals(this.startIndex, retargetingListServiceSelector.startIndex) && Objects.equals(this.targetListIds, retargetingListServiceSelector.targetListIds) && Objects.equals(this.targetListTypes, retargetingListServiceSelector.targetListTypes) && Objects.equals((Object)this.sharingStatusFilterType, (Object)retargetingListServiceSelector.sharingStatusFilterType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.numberResults, this.startIndex, this.targetListIds, this.targetListTypes, this.sharingStatusFilterType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetargetingListServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    targetListIds: ").append(this.toIndentedString(this.targetListIds)).append("\n");
        sb.append("    targetListTypes: ").append(this.toIndentedString(this.targetListTypes)).append("\n");
        sb.append("    sharingStatusFilterType: ").append(this.toIndentedString((Object)this.sharingStatusFilterType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

