/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dwango.cbb.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.co.dwango.cbb.db.DataBusHandler;
import jp.co.dwango.cbb.db.Logger;
import org.json.JSONArray;

public abstract class DataBus {
    private final Object locker = new Object();
    private final List<DataBusHandler> handlers = Collections.synchronizedList(new ArrayList());
    protected boolean destroyed = false;

    public static void logging(boolean enabled) {
        Logger.enabled = enabled;
    }

    public abstract void send(JSONArray var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(DataBusHandler handler) {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            if (0 <= this.handlers.indexOf(handler)) {
                return;
            }
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(DataBusHandler handler) {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            while (this.handlers.contains(handler)) {
                this.handlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHandlers() {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            this.handlers.clear();
        }
    }

    public int getHandlerCount() {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return 0;
        }
        return this.handlers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void received(JSONArray data) {
        if (this.destroyed) {
            Logger.e("already destroyed");
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            for (DataBusHandler h : this.handlers) {
                h.onReceive(data);
            }
        }
    }

    public void destroy() {
        if (!this.destroyed) {
            this.removeAllHandlers();
            this.destroyed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.destroy();
        }
    }
}

