/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageNativeLibrary;
import jp.co.cyberagent.android.gpuimage.OpenGlUtils;
import jp.co.cyberagent.android.gpuimage.Rotation;
import jp.co.cyberagent.android.gpuimage.util.TextureRotationUtil;

@TargetApi(value=11)
public class GPUImageRenderer
implements GLSurfaceView.Renderer,
Camera.PreviewCallback {
    public static final int NO_IMAGE = -1;
    static final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private GPUImageFilter mFilter;
    public final Object mSurfaceChangedWaiter = new Object();
    private int mGLTextureId = -1;
    private SurfaceTexture mSurfaceTexture = null;
    private final FloatBuffer mGLCubeBuffer;
    private final FloatBuffer mGLTextureBuffer;
    private IntBuffer mGLRgbBuffer;
    private int mOutputWidth;
    private int mOutputHeight;
    private int mImageWidth;
    private int mImageHeight;
    private int mAddedPadding;
    private final Queue<Runnable> mRunOnDraw;
    private final Queue<Runnable> mRunOnDrawEnd;
    private Rotation mRotation;
    private boolean mFlipHorizontal;
    private boolean mFlipVertical;
    private GPUImage.ScaleType mScaleType = GPUImage.ScaleType.CENTER_CROP;
    private float mBackgroundRed = 0.0f;
    private float mBackgroundGreen = 0.0f;
    private float mBackgroundBlue = 0.0f;

    public GPUImageRenderer(GPUImageFilter filter) {
        this.mFilter = filter;
        this.mRunOnDraw = new LinkedList<Runnable>();
        this.mRunOnDrawEnd = new LinkedList<Runnable>();
        this.mGLCubeBuffer = ByteBuffer.allocateDirect(CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLCubeBuffer.put(CUBE).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.setRotation(Rotation.NORMAL, false, false);
    }

    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
        GLES20.glClearColor((float)this.mBackgroundRed, (float)this.mBackgroundGreen, (float)this.mBackgroundBlue, (float)1.0f);
        GLES20.glDisable((int)2929);
        this.mFilter.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glUseProgram((int)this.mFilter.getProgram());
        this.mFilter.onOutputSizeChanged(width, height);
        this.adjustImageScaling();
        Object object = this.mSurfaceChangedWaiter;
        synchronized (object) {
            this.mSurfaceChangedWaiter.notifyAll();
        }
    }

    public void onDrawFrame(GL10 gl) {
        GLES20.glClear((int)16640);
        this.runAll(this.mRunOnDraw);
        this.mFilter.onDraw(this.mGLTextureId, this.mGLCubeBuffer, this.mGLTextureBuffer);
        this.runAll(this.mRunOnDrawEnd);
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.updateTexImage();
        }
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.mBackgroundRed = red;
        this.mBackgroundGreen = green;
        this.mBackgroundBlue = blue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Queue<Runnable> queue) {
        Queue<Runnable> queue2 = queue;
        synchronized (queue2) {
            while (!queue.isEmpty()) {
                queue.poll().run();
            }
        }
    }

    public void onPreviewFrame(final byte[] data, final Camera camera) {
        final Camera.Size previewSize = camera.getParameters().getPreviewSize();
        if (this.mGLRgbBuffer == null) {
            this.mGLRgbBuffer = IntBuffer.allocate(previewSize.width * previewSize.height);
        }
        if (this.mRunOnDraw.isEmpty()) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    GPUImageNativeLibrary.YUVtoRBGA(data, previewSize.width, previewSize.height, GPUImageRenderer.this.mGLRgbBuffer.array());
                    GPUImageRenderer.this.mGLTextureId = OpenGlUtils.loadTexture(GPUImageRenderer.this.mGLRgbBuffer, previewSize, GPUImageRenderer.this.mGLTextureId);
                    camera.addCallbackBuffer(data);
                    if (GPUImageRenderer.this.mImageWidth != previewSize.width) {
                        GPUImageRenderer.this.mImageWidth = previewSize.width;
                        GPUImageRenderer.this.mImageHeight = previewSize.height;
                        GPUImageRenderer.this.adjustImageScaling();
                    }
                }
            });
        }
    }

    public void setUpSurfaceTexture(final Camera camera) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                int[] textures = new int[1];
                GLES20.glGenTextures((int)1, (int[])textures, (int)0);
                GPUImageRenderer.this.mSurfaceTexture = new SurfaceTexture(textures[0]);
                try {
                    camera.setPreviewTexture(GPUImageRenderer.this.mSurfaceTexture);
                    camera.setPreviewCallback((Camera.PreviewCallback)GPUImageRenderer.this);
                    camera.startPreview();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setFilter(final GPUImageFilter filter) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GPUImageFilter oldFilter = GPUImageRenderer.this.mFilter;
                GPUImageRenderer.this.mFilter = filter;
                if (oldFilter != null) {
                    oldFilter.destroy();
                }
                GPUImageRenderer.this.mFilter.init();
                GLES20.glUseProgram((int)GPUImageRenderer.this.mFilter.getProgram());
                GPUImageRenderer.this.mFilter.onOutputSizeChanged(GPUImageRenderer.this.mOutputWidth, GPUImageRenderer.this.mOutputHeight);
            }
        });
    }

    public void deleteImage() {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{GPUImageRenderer.this.mGLTextureId}, (int)0);
                GPUImageRenderer.this.mGLTextureId = -1;
            }
        });
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, true);
    }

    public void setImageBitmap(final Bitmap bitmap, final boolean recycle) {
        if (bitmap == null) {
            return;
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                Bitmap resizedBitmap = null;
                if (bitmap.getWidth() % 2 == 1) {
                    resizedBitmap = Bitmap.createBitmap((int)(bitmap.getWidth() + 1), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas can = new Canvas(resizedBitmap);
                    can.drawARGB(0, 0, 0, 0);
                    can.drawBitmap(bitmap, 0.0f, 0.0f, null);
                    GPUImageRenderer.this.mAddedPadding = 1;
                } else {
                    GPUImageRenderer.this.mAddedPadding = 0;
                }
                GPUImageRenderer.this.mGLTextureId = OpenGlUtils.loadTexture(resizedBitmap != null ? resizedBitmap : bitmap, GPUImageRenderer.this.mGLTextureId, recycle);
                if (resizedBitmap != null) {
                    resizedBitmap.recycle();
                }
                GPUImageRenderer.this.mImageWidth = bitmap.getWidth();
                GPUImageRenderer.this.mImageHeight = bitmap.getHeight();
                GPUImageRenderer.this.adjustImageScaling();
            }
        });
    }

    public void setScaleType(GPUImage.ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    protected int getFrameWidth() {
        return this.mOutputWidth;
    }

    protected int getFrameHeight() {
        return this.mOutputHeight;
    }

    private void adjustImageScaling() {
        float outputWidth = this.mOutputWidth;
        float outputHeight = this.mOutputHeight;
        if (this.mRotation == Rotation.ROTATION_270 || this.mRotation == Rotation.ROTATION_90) {
            outputWidth = this.mOutputHeight;
            outputHeight = this.mOutputWidth;
        }
        float ratio1 = outputWidth / (float)this.mImageWidth;
        float ratio2 = outputHeight / (float)this.mImageHeight;
        float ratioMax = Math.max(ratio1, ratio2);
        int imageWidthNew = Math.round((float)this.mImageWidth * ratioMax);
        int imageHeightNew = Math.round((float)this.mImageHeight * ratioMax);
        float ratioWidth = (float)imageWidthNew / outputWidth;
        float ratioHeight = (float)imageHeightNew / outputHeight;
        float[] cube = CUBE;
        float[] textureCords = TextureRotationUtil.getRotation(this.mRotation, this.mFlipHorizontal, this.mFlipVertical);
        if (this.mScaleType == GPUImage.ScaleType.CENTER_CROP) {
            float distHorizontal = (1.0f - 1.0f / ratioWidth) / 2.0f;
            float distVertical = (1.0f - 1.0f / ratioHeight) / 2.0f;
            textureCords = new float[]{this.addDistance(textureCords[0], distHorizontal), this.addDistance(textureCords[1], distVertical), this.addDistance(textureCords[2], distHorizontal), this.addDistance(textureCords[3], distVertical), this.addDistance(textureCords[4], distHorizontal), this.addDistance(textureCords[5], distVertical), this.addDistance(textureCords[6], distHorizontal), this.addDistance(textureCords[7], distVertical)};
        } else {
            cube = new float[]{CUBE[0] / ratioHeight, CUBE[1] / ratioWidth, CUBE[2] / ratioHeight, CUBE[3] / ratioWidth, CUBE[4] / ratioHeight, CUBE[5] / ratioWidth, CUBE[6] / ratioHeight, CUBE[7] / ratioWidth};
        }
        this.mGLCubeBuffer.clear();
        this.mGLCubeBuffer.put(cube).position(0);
        this.mGLTextureBuffer.clear();
        this.mGLTextureBuffer.put(textureCords).position(0);
    }

    private float addDistance(float coordinate, float distance) {
        return coordinate == 0.0f ? distance : 1.0f - distance;
    }

    public void setRotationCamera(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.setRotation(rotation, flipVertical, flipHorizontal);
    }

    public void setRotation(Rotation rotation) {
        this.mRotation = rotation;
        this.adjustImageScaling();
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.mFlipHorizontal = flipHorizontal;
        this.mFlipVertical = flipVertical;
        this.setRotation(rotation);
    }

    public Rotation getRotation() {
        return this.mRotation;
    }

    public boolean isFlippedHorizontally() {
        return this.mFlipHorizontal;
    }

    public boolean isFlippedVertically() {
        return this.mFlipVertical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDrawEnd(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDrawEnd;
        synchronized (queue) {
            this.mRunOnDrawEnd.add(runnable);
        }
    }
}

