/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImageFalseColorFilter
extends GPUImageFilter {
    public static final String FALSECOLOR_FRAGMENT_SHADER = "precision lowp float;\n\nvarying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform float intensity;\nuniform vec3 firstColor;\nuniform vec3 secondColor;\n\nconst mediump vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n\nvoid main()\n{\nlowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\nfloat luminance = dot(textureColor.rgb, luminanceWeighting);\n\ngl_FragColor = vec4( mix(firstColor.rgb, secondColor.rgb, luminance), textureColor.a);\n}\n";
    private float[] mFirstColor;
    private int mFirstColorLocation;
    private float[] mSecondColor;
    private int mSecondColorLocation;

    public GPUImageFalseColorFilter() {
        this(0.0f, 0.0f, 0.5f, 1.0f, 0.0f, 0.0f);
    }

    public GPUImageFalseColorFilter(float firstRed, float firstGreen, float firstBlue, float secondRed, float secondGreen, float secondBlue) {
        this(new float[]{firstRed, firstGreen, firstBlue}, new float[]{secondRed, secondGreen, secondBlue});
    }

    public GPUImageFalseColorFilter(float[] firstColor, float[] secondColor) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", FALSECOLOR_FRAGMENT_SHADER);
        this.mFirstColor = firstColor;
        this.mSecondColor = secondColor;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mFirstColorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"firstColor");
        this.mSecondColorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"secondColor");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setFirstColor(this.mFirstColor);
        this.setSecondColor(this.mSecondColor);
    }

    public void setFirstColor(float[] firstColor) {
        this.mFirstColor = firstColor;
        this.setFloatVec3(this.mFirstColorLocation, firstColor);
    }

    public void setSecondColor(float[] secondColor) {
        this.mSecondColor = secondColor;
        this.setFloatVec3(this.mSecondColorLocation, secondColor);
    }
}

