/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.PointF;
import android.opengl.GLES20;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import java.util.Scanner;
import jp.co.cyberagent.android.gpuimage.OpenGlUtils;

public class GPUImageFilter {
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    private final LinkedList<Runnable> mRunOnDraw = new LinkedList();
    private final String mVertexShader;
    private final String mFragmentShader;
    protected int mGLProgId;
    protected int mGLAttribPosition;
    protected int mGLUniformTexture;
    protected int mGLAttribTextureCoordinate;
    protected int mOutputWidth;
    protected int mOutputHeight;
    private boolean mIsInitialized;

    public GPUImageFilter() {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
    }

    public GPUImageFilter(String vertexShader, String fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
    }

    public final void init() {
        this.onInit();
        this.mIsInitialized = true;
        this.onInitialized();
    }

    public void onInit() {
        this.mGLProgId = OpenGlUtils.loadProgram(this.mVertexShader, this.mFragmentShader);
        this.mGLAttribPosition = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"position");
        this.mGLUniformTexture = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"inputImageTexture");
        this.mGLAttribTextureCoordinate = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"inputTextureCoordinate");
        this.mIsInitialized = true;
    }

    public void onInitialized() {
    }

    public final void destroy() {
        this.mIsInitialized = false;
        GLES20.glDeleteProgram((int)this.mGLProgId);
        this.onDestroy();
    }

    public void onDestroy() {
    }

    public void onOutputSizeChanged(int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }

    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        GLES20.glUseProgram((int)this.mGLProgId);
        this.runPendingOnDrawTasks();
        if (!this.mIsInitialized) {
            return;
        }
        cubeBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)cubeBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
        }
        this.onDrawArraysPre();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    protected void onDrawArraysPre() {
    }

    protected void runPendingOnDrawTasks() {
        while (!this.mRunOnDraw.isEmpty()) {
            this.mRunOnDraw.removeFirst().run();
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public int getOutputWidth() {
        return this.mOutputWidth;
    }

    public int getOutputHeight() {
        return this.mOutputHeight;
    }

    public int getProgram() {
        return this.mGLProgId;
    }

    public int getAttribPosition() {
        return this.mGLAttribPosition;
    }

    public int getAttribTextureCoordinate() {
        return this.mGLAttribTextureCoordinate;
    }

    public int getUniformTexture() {
        return this.mGLUniformTexture;
    }

    protected void setInteger(final int location, final int intValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1i((int)location, (int)intValue);
            }
        });
    }

    protected void setFloat(final int location, final float floatValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)location, (float)floatValue);
            }
        });
    }

    protected void setFloatVec2(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform2fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec3(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec4(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatArray(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1fv((int)location, (int)arrayValue.length, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setPoint(final int location, final PointF point) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                float[] vec2 = new float[]{point.x, point.y};
                GLES20.glUniform2fv((int)location, (int)1, (float[])vec2, (int)0);
            }
        });
    }

    protected void setUniformMatrix3f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix3fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    protected void setUniformMatrix4f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.mRunOnDraw;
        synchronized (linkedList) {
            this.mRunOnDraw.addLast(runnable);
        }
    }

    public static String loadShader(String file, Context context) {
        try {
            AssetManager assetManager = context.getAssets();
            InputStream ims = assetManager.open(file);
            String re = GPUImageFilter.convertStreamToString(ims);
            ims.close();
            return re;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

