/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.OpenGlUtils;
import jp.co.cyberagent.android.gpuimage.Rotation;
import jp.co.cyberagent.android.gpuimage.util.TextureRotationUtil;

public class GPUImageTwoInputFilter
extends GPUImageFilter {
    private static final String VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n}";
    public int mFilterSecondTextureCoordinateAttribute;
    public int mFilterInputTextureUniform2;
    public int mFilterSourceTexture2 = -1;
    private ByteBuffer mTexture2CoordinatesBuffer;
    private Bitmap mBitmap;

    public GPUImageTwoInputFilter(String fragmentShader) {
        this(VERTEX_SHADER, fragmentShader);
    }

    public GPUImageTwoInputFilter(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
        this.setRotation(Rotation.NORMAL, false, false);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mFilterSecondTextureCoordinateAttribute = GLES20.glGetAttribLocation((int)this.getProgram(), (String)"inputTextureCoordinate2");
        this.mFilterInputTextureUniform2 = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputImageTexture2");
        GLES20.glEnableVertexAttribArray((int)this.mFilterSecondTextureCoordinateAttribute);
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.setBitmap(this.mBitmap);
        }
    }

    public void setBitmap(final Bitmap bitmap) {
        if (bitmap != null && bitmap.isRecycled()) {
            return;
        }
        this.mBitmap = bitmap;
        if (this.mBitmap == null) {
            return;
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                if (GPUImageTwoInputFilter.this.mFilterSourceTexture2 == -1) {
                    if (bitmap == null || bitmap.isRecycled()) {
                        return;
                    }
                    GLES20.glActiveTexture((int)33987);
                    GPUImageTwoInputFilter.this.mFilterSourceTexture2 = OpenGlUtils.loadTexture(bitmap, -1, false);
                }
            }
        });
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void recycleBitmap() {
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mFilterSourceTexture2}, (int)0);
        this.mFilterSourceTexture2 = -1;
    }

    @Override
    protected void onDrawArraysPre() {
        GLES20.glEnableVertexAttribArray((int)this.mFilterSecondTextureCoordinateAttribute);
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.mFilterSourceTexture2);
        GLES20.glUniform1i((int)this.mFilterInputTextureUniform2, (int)3);
        this.mTexture2CoordinatesBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mFilterSecondTextureCoordinateAttribute, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTexture2CoordinatesBuffer);
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] buffer = TextureRotationUtil.getRotation(rotation, flipHorizontal, flipVertical);
        ByteBuffer bBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder());
        FloatBuffer fBuffer = bBuffer.asFloatBuffer();
        fBuffer.put(buffer);
        fBuffer.flip();
        this.mTexture2CoordinatesBuffer = bBuffer;
    }
}

