/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.classmethod.aws.gradle.sqs.AbstractAmazonSQSTask;
import jp.classmethod.aws.gradle.sqs.AmazonSQSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class AmazonSQSSendMessagesTask
extends AbstractAmazonSQSTask {
    private static final int MAX_MESSAGE_SEND_BATCH_SIZE = 10;
    private Stream<String> messages;

    public AmazonSQSSendMessagesTask() {
        this.setDescription("Send messages to SQS");
        this.setGroup("AWS");
    }

    @TaskAction
    public void sendMessages() {
        String queueUrl = this.getQueueUrl();
        Stream<String> messages = this.getMessages();
        if (queueUrl == null) {
            throw new GradleException("Must specify either queueName or queueUrl");
        }
        if (messages == null) {
            throw new GradleException("Must provide messages to send to SQS");
        }
        AmazonSQSPluginExtension ext = (AmazonSQSPluginExtension)this.getProject().getExtensions().getByType(AmazonSQSPluginExtension.class);
        AmazonSQS sqs = (AmazonSQS)ext.getClient();
        AtomicInteger counter = new AtomicInteger(0);
        List messageEntries = messages.map(message -> new SendMessageBatchRequestEntry().withId("gradle_message_index_" + counter.getAndIncrement()).withMessageBody(message)).collect(Collectors.toList());
        this.getLogger().info("Sending {} messages to {}", (Object)messageEntries.size(), (Object)queueUrl);
        Lists.partition(messageEntries, (int)10).parallelStream().forEach(messagesToSend -> sqs.sendMessageBatch(new SendMessageBatchRequest().withQueueUrl(queueUrl).withEntries((Collection)messagesToSend)));
    }

    public Stream<String> getMessages() {
        return this.messages;
    }

    public void setMessages(Stream<String> messages) {
        this.messages = messages;
    }
}

