/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.auth.policy.Policy;
import com.amazonaws.services.s3.AmazonS3;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class BucketPolicyTask
extends ConventionTask {
    private String bucketName;
    private Policy policy;

    public BucketPolicyTask() {
        this.setDescription("Set an S3 bucket policy");
        this.setGroup("AWS");
    }

    @TaskAction
    public void applyBucketPolicy() {
        String bucketName = this.getBucketName();
        Policy policy = this.getPolicy();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        if (policy == null) {
            throw new GradleException("policy is not specified");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        String policyJson = policy.toJson();
        this.getLogger().info("Setting s3://{} bucket policy to {}", (Object)bucketName, (Object)policyJson);
        s3.setBucketPolicy(bucketName, policy.toJson());
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }
}

