/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import jp.classmethod.aws.gradle.s3.AbstractAmazonS3FileUploadTask;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class AmazonS3ProgressiveFileUploadTask
extends AbstractAmazonS3FileUploadTask {
    public AmazonS3ProgressiveFileUploadTask() {
        this.setDescription("Upload file to the Amazon S3 bucket.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void upload() throws InterruptedException {
        String bucketName = this.getBucketName();
        String key = this.getKey();
        File file = this.getFile();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        if (key == null) {
            throw new GradleException("key is not specified");
        }
        if (file == null) {
            throw new GradleException("file is not specified");
        }
        if (!file.isFile()) {
            throw new GradleException("file must be regular file");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        TransferManager s3mgr = TransferManagerBuilder.standard().withS3Client(s3).build();
        this.getLogger().info("Uploading... s3://{}/{}", (Object)bucketName, (Object)key);
        final Upload upload = s3mgr.upload(new PutObjectRequest(this.getBucketName(), this.getKey(), this.getFile()).withMetadata(this.getObjectMetadata()));
        upload.addProgressListener(new ProgressListener(){

            public void progressChanged(ProgressEvent event) {
                AmazonS3ProgressiveFileUploadTask.this.getLogger().info("  {}% uploaded", (Object)upload.getProgress().getPercentTransferred());
            }
        });
        upload.waitForCompletion();
        this.setResourceUrl(s3.getUrl(bucketName, key).toString());
        this.getLogger().info("Upload completed: {}", (Object)this.getResourceUrl());
    }
}

