/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.services.s3.AmazonS3;
import java.util.List;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonS3DeleteAllFilesTask
extends ConventionTask {
    public String bucketName;
    public String prefix = "";

    public AmazonS3DeleteAllFilesTask() {
        this.setDescription("Delete all files in the S3 bucket.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void delete() {
        List objectSummaries;
        String bucketName = this.getBucketName();
        String prefix = this.getPrefix();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        this.getLogger().info("Delete s3://{}/{}*", (Object)bucketName, (Object)prefix);
        while (!(objectSummaries = s3.listObjects(bucketName, prefix).getObjectSummaries()).isEmpty()) {
            objectSummaries.forEach(os -> {
                this.getLogger().info("  Deleting... s3://{}/{}", (Object)bucketName, (Object)os.getKey());
                s3.deleteObject(bucketName, os.getKey());
            });
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

