/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.route53;

import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.HostedZoneAlreadyExistsException;
import com.amazonaws.services.route53.model.HostedZoneConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import jp.classmethod.aws.gradle.route53.AmazonRoute53PluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class CreateHostedZoneTask
extends ConventionTask {
    private String hostedZoneName;
    private String callerReference;
    private String comment;
    private CreateHostedZoneResult createHostedZoneResult;
    private String hostedZoneId;
    private List<String> nameServers;

    @TaskAction
    public void createHostedZone() throws UnknownHostException {
        String hostedZoneName = this.getHostedZoneName();
        String callerReference = this.getCallerReference() != null ? this.getCallerReference() : InetAddress.getLocalHost().getHostName();
        String comment = this.getComment();
        AmazonRoute53PluginExtension ext = (AmazonRoute53PluginExtension)this.getProject().getExtensions().getByType(AmazonRoute53PluginExtension.class);
        AmazonRoute53 route53 = (AmazonRoute53)ext.getClient();
        this.getLogger().info("callerRef = {}", (Object)callerReference);
        CreateHostedZoneRequest req = new CreateHostedZoneRequest().withName(hostedZoneName).withCallerReference(callerReference);
        if (comment != null) {
            req.setHostedZoneConfig(new HostedZoneConfig().withComment(comment));
        }
        try {
            this.createHostedZoneResult = route53.createHostedZone(req);
            this.nameServers = this.createHostedZoneResult.getDelegationSet().getNameServers();
            this.hostedZoneId = this.createHostedZoneResult.getHostedZone().getId();
            this.getLogger().info("HostedZone {} ({} - {})  is created.", new Object[]{this.hostedZoneId, hostedZoneName, callerReference});
            this.nameServers.forEach(it -> this.getLogger().info("  NS {}", it));
        }
        catch (HostedZoneAlreadyExistsException e) {
            this.getLogger().error("HostedZone {} - {} is already created.", (Object)hostedZoneName, (Object)callerReference);
        }
    }

    public String getHostedZoneName() {
        return this.hostedZoneName;
    }

    public void setHostedZoneName(String hostedZoneName) {
        this.hostedZoneName = hostedZoneName;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public void setCallerReference(String callerReference) {
        this.callerReference = callerReference;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateHostedZoneResult getCreateHostedZoneResult() {
        return this.createHostedZoneResult;
    }

    public String getHostedZoneId() {
        return this.hostedZoneId;
    }

    public List<String> getNameServers() {
        return this.nameServers;
    }
}

