/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBCluster;
import com.amazonaws.services.rds.model.DBClusterNotFoundException;
import com.amazonaws.services.rds.model.DescribeDBClustersRequest;
import com.amazonaws.services.rds.model.DescribeDBClustersResult;
import java.util.Arrays;
import java.util.List;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSWaitClusterStatusTask
extends ConventionTask {
    private String dbClusterIdentifier;
    private List<String> successStatuses = Arrays.asList("available", "backing-up", "terminated");
    private List<String> waitStatuses = Arrays.asList("creating", "deleting", "modifying", "rebooting", "renaming", "resetting-master-credentials");
    private int loopTimeout = 900;
    private int loopWait = 10;
    private boolean found;
    private String lastStatus;

    public AmazonRDSWaitClusterStatusTask() {
        this.setDescription("Wait RDS cluster for specific status.");
        this.setGroup("AWS");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void waitClusterForStatus() {
        String dbClusterIdentifier = this.getDbClusterIdentifier();
        List<String> successStatuses = this.getSuccessStatuses();
        List<String> waitStatuses = this.getWaitStatuses();
        int loopTimeout = this.getLoopTimeout();
        int loopWait = this.getLoopWait();
        if (dbClusterIdentifier == null) {
            throw new GradleException("dbClusterIdentifier is not specified");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        long start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > start + (long)(loopTimeout * 1000)) {
                throw new GradleException("Timeout");
            }
            try {
                DescribeDBClustersResult dir = rds.describeDBClusters(new DescribeDBClustersRequest().withDBClusterIdentifier(dbClusterIdentifier));
                DBCluster dbCluster = (DBCluster)dir.getDBClusters().get(0);
                this.found = true;
                this.lastStatus = dbCluster.getStatus();
                if (successStatuses.contains(this.lastStatus)) {
                    this.getLogger().info("Status of DB cluster {} is now {}.", (Object)dbClusterIdentifier, (Object)this.lastStatus);
                    return;
                }
                if (!waitStatuses.contains(this.lastStatus)) throw new GradleException("Status of " + dbClusterIdentifier + " is " + this.lastStatus + ".  It seems to be failed.");
                this.getLogger().info("Status of DB cluster {} is {}...", (Object)dbClusterIdentifier, (Object)this.lastStatus);
                try {
                    Thread.sleep(loopWait * 1000);
                }
                catch (InterruptedException e) {
                    throw new GradleException("Sleep interrupted", (Throwable)e);
                }
            }
            catch (DBClusterNotFoundException e) {
                throw new GradleException(dbClusterIdentifier + " does not exist", (Throwable)e);
            }
            catch (AmazonServiceException e) {
                if (!this.found) throw new GradleException("Fail to describe instance: " + dbClusterIdentifier, (Throwable)e);
                return;
            }
        }
    }

    public String getDbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public void setDbClusterIdentifier(String dbClusterIdentifier) {
        this.dbClusterIdentifier = dbClusterIdentifier;
    }

    public List<String> getSuccessStatuses() {
        return this.successStatuses;
    }

    public void setSuccessStatuses(List<String> successStatuses) {
        this.successStatuses = successStatuses;
    }

    public List<String> getWaitStatuses() {
        return this.waitStatuses;
    }

    public void setWaitStatuses(List<String> waitStatuses) {
        this.waitStatuses = waitStatuses;
    }

    public int getLoopTimeout() {
        return this.loopTimeout;
    }

    public void setLoopTimeout(int loopTimeout) {
        this.loopTimeout = loopTimeout;
    }

    public int getLoopWait() {
        return this.loopWait;
    }

    public void setLoopWait(int loopWait) {
        this.loopWait = loopWait;
    }

    public boolean isFound() {
        return this.found;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }
}

