/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import java.util.List;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSModifyDBInstanceTask
extends ConventionTask {
    private String dbInstanceIdentifier;
    private Integer allocatedStorage;
    private String dbInstanceClass;
    private String masterUserPassword;
    private List<String> vpcSecurityGroupIds;
    private String preferredMaintenanceWindow;
    private String dbParameterGroupName;
    private Integer backupRetentionPeriod;
    private String preferredBackupWindow;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private Integer iops;
    private String optionGroupName;
    private String storageType;
    private String tdeCredentialArn;
    private String tdeCredentialPassword;
    private DBInstance dbInstance;

    public AmazonRDSModifyDBInstanceTask() {
        this.setDescription("Modify RDS instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void modifyDBInstance() {
        String dbInstanceIdentifier = this.getDbInstanceIdentifier();
        if (dbInstanceIdentifier == null) {
            throw new GradleException("dbInstanceIdentifier is required");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        ModifyDBInstanceRequest request = new ModifyDBInstanceRequest().withDBInstanceIdentifier(dbInstanceIdentifier).withAllocatedStorage(this.getAllocatedStorage()).withDBInstanceClass(this.getDbInstanceClass()).withMasterUserPassword(this.getMasterUserPassword()).withVpcSecurityGroupIds(this.getVpcSecurityGroupIds()).withPreferredMaintenanceWindow(this.getPreferredMaintenanceWindow()).withDBParameterGroupName(this.getDbParameterGroupName()).withBackupRetentionPeriod(this.getBackupRetentionPeriod()).withPreferredBackupWindow(this.getPreferredBackupWindow()).withMultiAZ(this.getMultiAZ()).withEngineVersion(this.getEngineVersion()).withAutoMinorVersionUpgrade(this.getAutoMinorVersionUpgrade()).withIops(this.getIops()).withOptionGroupName(this.getOptionGroupName()).withStorageType(this.getStorageType()).withTdeCredentialArn(this.getTdeCredentialArn()).withTdeCredentialPassword(this.getTdeCredentialPassword());
        this.dbInstance = rds.modifyDBInstance(request);
        this.getLogger().info("Modify RDS instance requested: {}", (Object)this.dbInstance.getDBInstanceIdentifier());
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public String getDbInstanceClass() {
        return this.dbInstanceClass;
    }

    public void setDbInstanceClass(String dbInstanceClass) {
        this.dbInstanceClass = dbInstanceClass;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public List<String> getVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
        this.vpcSecurityGroupIds = vpcSecurityGroupIds;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getDbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public void setDbParameterGroupName(String dbParameterGroupName) {
        this.dbParameterGroupName = dbParameterGroupName;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getTdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    public String getTdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public void setTdeCredentialPassword(String tdeCredentialPassword) {
        this.tdeCredentialPassword = tdeCredentialPassword;
    }

    public DBInstance getDbInstance() {
        return this.dbInstance;
    }
}

