/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.Filter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSDescribeInstancesTask
extends ConventionTask {
    private String dbInstanceIdentifier;
    private int maxRecords = 50;
    private Map<String, List<String>> filters;
    private List<DBInstance> dbInstances;

    public AmazonRDSDescribeInstancesTask() {
        this.setDescription("Describe AWS instances.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void describeDBInstances() {
        String dbInstanceIdentifier = this.getDbInstanceIdentifier();
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        try {
            DescribeDBInstancesRequest request = new DescribeDBInstancesRequest().withMaxRecords(Integer.valueOf(this.getMaxRecords()));
            if (this.getDbInstanceIdentifier() != null && this.getDbInstanceIdentifier().length() > 0) {
                request.withDBInstanceIdentifier(this.getDbInstanceIdentifier());
            }
            if (this.getFilters() != null) {
                request.withFilters((Collection)this.getFilters().entrySet().stream().map(it -> new Filter().withName(((String)it.getKey()).toString()).withValues((Collection)it.getValue())).collect(Collectors.toList()));
            }
            DescribeDBInstancesResult dir = rds.describeDBInstances(request);
            this.dbInstances = dir.getDBInstances();
        }
        catch (AmazonServiceException e) {
            throw new GradleException("Fail to describe instance: " + dbInstanceIdentifier, (Throwable)e);
        }
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public Map<String, List<String>> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, List<String>> filters) {
        this.filters = filters;
    }

    public List<DBInstance> getDbInstances() {
        return this.dbInstances;
    }
}

