/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBCluster;
import com.amazonaws.services.rds.model.DBInstanceNotFoundException;
import com.amazonaws.services.rds.model.DeleteDBClusterRequest;
import jp.classmethod.aws.gradle.rds.AmazonRDSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonRDSDeleteDBClusterTask
extends ConventionTask {
    private String dbClusterIdentifier;
    private boolean skipFinalSnapshot;
    private String finalDBSnapshotIdentifier;
    private DBCluster dbCluster;

    public AmazonRDSDeleteDBClusterTask() {
        this.setDescription("Delete RDS cluster.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteDBInstance() {
        String dbClusterIdentifier = this.getDbClusterIdentifier();
        if (dbClusterIdentifier == null) {
            throw new GradleException("dbClusterIdentifier is required");
        }
        AmazonRDSPluginExtension ext = (AmazonRDSPluginExtension)this.getProject().getExtensions().getByType(AmazonRDSPluginExtension.class);
        AmazonRDS rds = (AmazonRDS)ext.getClient();
        try {
            DeleteDBClusterRequest request = new DeleteDBClusterRequest().withDBClusterIdentifier(dbClusterIdentifier).withSkipFinalSnapshot(Boolean.valueOf(this.isSkipFinalSnapshot())).withFinalDBSnapshotIdentifier(this.getFinalDBSnapshotIdentifier());
            this.dbCluster = rds.deleteDBCluster(request);
            this.getLogger().info("Delete RDS cluster requested: {}", (Object)this.dbCluster.getDBClusterIdentifier());
        }
        catch (DBInstanceNotFoundException e) {
            this.getLogger().warn(e.getMessage());
        }
    }

    public String getDbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public void setDbClusterIdentifier(String dbClusterIdentifier) {
        this.dbClusterIdentifier = dbClusterIdentifier;
    }

    public boolean isSkipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public void setSkipFinalSnapshot(boolean skipFinalSnapshot) {
        this.skipFinalSnapshot = skipFinalSnapshot;
    }

    public String getFinalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    public void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
        this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
    }

    public DBCluster getDbCluster() {
        return this.dbCluster;
    }
}

