/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.services.lambda.model.LogType;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaInvokeTask
extends ConventionTask {
    private String functionName;
    private InvocationType invocationType;
    private LogType logType = LogType.None;
    private String clientContext;
    private String qualifier;
    private Object payload;
    private InvokeResult invokeResult;

    public AWSLambdaInvokeTask() {
        this.setDescription("Invoke Lambda function.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void invokeFunction() throws FileNotFoundException, IOException {
        String functionName = this.getFunctionName();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        AWSLambda lambda = (AWSLambda)ext.getClient();
        InvokeRequest request = new InvokeRequest().withFunctionName(functionName).withInvocationType(this.getInvocationType()).withLogType(this.getLogType()).withClientContext(this.getClientContext()).withQualifier(this.getQualifier());
        this.setupPayload(request);
        this.invokeResult = lambda.invoke(request);
        this.getLogger().info("Invoke Lambda function requested: {}", (Object)functionName);
    }

    private void setupPayload(InvokeRequest request) throws IOException {
        Object payload = this.getPayload();
        if (payload instanceof ByteBuffer) {
            request.setPayload((ByteBuffer)payload);
            return;
        }
        if (payload != null) {
            String str;
            if (payload instanceof File) {
                File file = (File)payload;
                str = Files.toString((File)file, (Charset)Charsets.UTF_8);
            } else if (payload instanceof Closure) {
                Closure closure = (Closure)payload;
                str = closure.call().toString();
            } else {
                str = payload instanceof String ? (String)payload : payload.toString();
            }
            request.setPayload(str);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public void setInvocationType(InvocationType invocationType) {
        this.invocationType = invocationType;
    }

    public LogType getLogType() {
        return this.logType;
    }

    public void setLogType(LogType logType) {
        this.logType = logType;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    public void setClientContext(String clientContext) {
        this.clientContext = clientContext;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public InvokeResult getInvokeResult() {
        return this.invokeResult;
    }
}

