/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.lambda.model.VpcConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import jp.classmethod.aws.gradle.lambda.S3File;
import jp.classmethod.aws.gradle.lambda.VpcConfigWrapper;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaCreateFunctionTask
extends ConventionTask {
    private String functionName;
    private String role;
    private Runtime runtime = Runtime.Nodejs;
    private String handler;
    private String functionDescription;
    private Integer timeout;
    private Integer memorySize;
    private File zipFile;
    private S3File s3File;
    private VpcConfigWrapper vpc;
    private Map<String, String> environment;
    private Map<String, String> tags;
    private Boolean publish;
    private CreateFunctionResult createFunctionResult;

    public AWSLambdaCreateFunctionTask() {
        this.setDescription("Create Lambda function.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createFunction() throws FileNotFoundException, IOException {
        FunctionCode functionCode;
        AWSLambda lambda;
        block27: {
            String functionName = this.getFunctionName();
            if (functionName == null) {
                throw new GradleException("functionName is required");
            }
            File zipFile = this.getZipFile();
            S3File s3File = this.getS3File();
            if (zipFile == null && s3File == null || zipFile != null && s3File != null) {
                throw new GradleException("exactly one of zipFile or s3File is required");
            }
            AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
            lambda = (AWSLambda)ext.getClient();
            if (zipFile != null) {
                try (RandomAccessFile raf = new RandomAccessFile(this.getZipFile(), "r");
                     FileChannel channel = raf.getChannel();){
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                    buffer.load();
                    functionCode = new FunctionCode().withZipFile((ByteBuffer)buffer);
                    break block27;
                }
            }
            s3File.validate();
            functionCode = new FunctionCode().withS3Bucket(s3File.getBucketName()).withS3Key(s3File.getKey()).withS3ObjectVersion(s3File.getObjectVersion());
        }
        CreateFunctionRequest request = new CreateFunctionRequest().withFunctionName(this.getFunctionName()).withRuntime(this.getRuntime()).withRole(this.getRole()).withHandler(this.getHandler()).withDescription(this.getFunctionDescription()).withTimeout(this.getTimeout()).withMemorySize(this.getMemorySize()).withPublish(this.getPublish()).withVpcConfig(this.getVpcConfig()).withEnvironment(new Environment().withVariables(this.getEnvironment())).withTags(this.getTags()).withCode(functionCode);
        this.createFunctionResult = lambda.createFunction(request);
        this.getLogger().info("Create Lambda function requested: {}", (Object)this.createFunctionResult.getFunctionArn());
    }

    private VpcConfig getVpcConfig() {
        if (this.getVpc() != null) {
            return this.getVpc().toVpcConfig();
        }
        return null;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public S3File getS3File() {
        return this.s3File;
    }

    public void setS3File(S3File s3File) {
        this.s3File = s3File;
    }

    public VpcConfigWrapper getVpc() {
        return this.vpc;
    }

    public void setVpc(VpcConfigWrapper vpc) {
        this.vpc = vpc;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Boolean getPublish() {
        return this.publish;
    }

    public void setPublish(Boolean publish) {
        this.publish = publish;
    }

    public CreateFunctionResult getCreateFunctionResult() {
        return this.createFunctionResult;
    }
}

