/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkDeleteConfigurationTemplateTask
extends ConventionTask {
    private String applicationName;
    private String templateName;

    public AWSElasticBeanstalkDeleteConfigurationTemplateTask() {
        this.setDescription("Delete ElasticBeanstalk Configuration Templates.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteTemplate() {
        String applicationName = this.getApplicationName();
        String templateName = this.getTemplateName();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        eb.deleteConfigurationTemplate(new DeleteConfigurationTemplateRequest().withApplicationName(applicationName).withTemplateName(templateName));
        this.getLogger().info("configuration template " + templateName + " @ " + applicationName + " deleted");
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
}

