/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkDeleteApplicationVersionTask
extends ConventionTask {
    private String applicationName;
    private String versionLabel;
    private String bucketName;
    private boolean deleteSourceBundle = true;

    public AWSElasticBeanstalkDeleteApplicationVersionTask() {
        this.setDescription("Delete ElasticBeanstalk Application Version.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void deleteVersion() {
        String applicationName = this.getApplicationName();
        String versionLabel = this.getVersionLabel();
        boolean deleteSourceBundle = this.isDeleteSourceBundle();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        eb.deleteApplicationVersion(new DeleteApplicationVersionRequest().withApplicationName(applicationName).withVersionLabel(versionLabel).withDeleteSourceBundle(Boolean.valueOf(deleteSourceBundle)));
        this.getLogger().info("version " + versionLabel + " deleted");
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isDeleteSourceBundle() {
        return this.deleteSourceBundle;
    }

    public void setDeleteSourceBundle(boolean deleteSourceBundle) {
        this.deleteSourceBundle = deleteSourceBundle;
    }
}

