/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkCreateApplicationVersionTask
extends ConventionTask {
    private String appName;
    private String versionLabel;
    private String bucketName;
    private String key;

    public AWSElasticBeanstalkCreateApplicationVersionTask() {
        this.setDescription("Create/Migrate ElasticBeanstalk Application Version.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createVersion() {
        String appName = this.getAppName();
        String versionLabel = this.getVersionLabel();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        try {
            eb.createApplicationVersion(new CreateApplicationVersionRequest().withApplicationName(appName).withVersionLabel(versionLabel).withSourceBundle(new S3Location(this.getBucketName(), this.getKey())));
            this.getLogger().info("version " + versionLabel + " @ " + appName + " created");
        }
        catch (AmazonServiceException e) {
            if (!e.getMessage().contains("already exists.")) {
                throw e;
            }
            this.getLogger().warn("version " + versionLabel + " @ " + appName + " already exists.");
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

