/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ecr;

import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.model.AuthorizationData;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import java.util.List;
import jp.classmethod.aws.gradle.ecr.AmazonECRPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonECRGetAuthorizationTokenTask
extends ConventionTask {
    private List<String> repositoryIds;
    private List<AuthorizationData> authorizationData;

    public AmazonECRGetAuthorizationTokenTask() {
        this.setDescription("Get authorization token for ECR repository");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createRepository() {
        List<String> repositoryIds = this.getRepositoryIds();
        if (repositoryIds == null || repositoryIds.isEmpty()) {
            throw new GradleException("Must specify ECR repositoryIds");
        }
        AmazonECRPluginExtension ext = (AmazonECRPluginExtension)this.getProject().getExtensions().getByType(AmazonECRPluginExtension.class);
        AmazonECR ecr = (AmazonECR)ext.getClient();
        GetAuthorizationTokenResult result = ecr.getAuthorizationToken(new GetAuthorizationTokenRequest().withRegistryIds(repositoryIds));
        this.authorizationData = result.getAuthorizationData();
    }

    public List<String> getRepositoryIds() {
        return this.repositoryIds;
    }

    public void setRepositoryIds(List<String> repositoryIds) {
        this.repositoryIds = repositoryIds;
    }

    public List<AuthorizationData> getAuthorizationData() {
        return this.authorizationData;
    }
}

