/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ecr;

import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.model.CreateRepositoryRequest;
import com.amazonaws.services.ecr.model.CreateRepositoryResult;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecr.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecr.model.Repository;
import com.amazonaws.services.ecr.model.RepositoryAlreadyExistsException;
import com.google.common.base.MoreObjects;
import java.util.Iterator;
import jp.classmethod.aws.gradle.ecr.AmazonECRPluginExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonECRCreateRepositoryTask
extends ConventionTask {
    private String repositoryName;
    private Repository repository;

    public AmazonECRCreateRepositoryTask() {
        this.setDescription("Create ECR repository");
        this.setGroup("AWS");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void createRepository() {
        AmazonECRPluginExtension ext = (AmazonECRPluginExtension)this.getProject().getExtensions().getByType(AmazonECRPluginExtension.class);
        AmazonECR ecr = (AmazonECR)ext.getClient();
        String repositoryName = (String)MoreObjects.firstNonNull((Object)this.getRepositoryName(), (Object)ext.getRepositoryName());
        try {
            CreateRepositoryResult result = ecr.createRepository(new CreateRepositoryRequest().withRepositoryName(repositoryName));
            this.repository = result.getRepository();
            return;
        }
        catch (RepositoryAlreadyExistsException ex) {
            Repository repositoryResult;
            DescribeRepositoriesResult describeRepositoriesResult = ecr.describeRepositories(new DescribeRepositoriesRequest());
            Iterator iterator = describeRepositoriesResult.getRepositories().iterator();
            do {
                if (!iterator.hasNext()) return;
            } while (!(repositoryResult = (Repository)iterator.next()).getRepositoryName().equals(repositoryName));
            this.repository = repositoryResult;
            return;
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public Repository getRepository() {
        return this.repository;
    }
}

