/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.amazonaws.services.ec2.model.ImportKeyPairResult;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2ImportKeyTask
extends ConventionTask {
    private String keyName;
    private String publicKeyMaterial;
    public boolean ifNotExists;
    private ImportKeyPairResult importKeyPairResult;

    public AmazonEC2ImportKeyTask() {
        this.setDescription("Start EC2 instance.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void importKey() {
        String keyName = this.getKeyName();
        String publicKeyMaterial = this.getPublicKeyMaterial();
        if (keyName == null) {
            throw new GradleException("keyName is required");
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        if (!this.isIfNotExists() || !this.exists(ec2)) {
            this.importKeyPairResult = ec2.importKeyPair(new ImportKeyPairRequest(keyName, publicKeyMaterial));
            this.getLogger().info("KeyPair imported: {}", (Object)this.importKeyPairResult.getKeyFingerprint());
        }
    }

    private boolean exists(AmazonEC2 ec2) {
        String keyName = this.getKeyName();
        try {
            DescribeKeyPairsResult describeKeyPairsResult = ec2.describeKeyPairs(new DescribeKeyPairsRequest().withKeyNames(new String[]{keyName}));
            return !describeKeyPairsResult.getKeyPairs().isEmpty();
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getPublicKeyMaterial() {
        return this.publicKeyMaterial;
    }

    public void setPublicKeyMaterial(String publicKeyMaterial) {
        this.publicKeyMaterial = publicKeyMaterial;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public ImportKeyPairResult getImportKeyPairResult() {
        return this.importKeyPairResult;
    }
}

