/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2DeleteSecurityGroupTask
extends ConventionTask {
    private String groupName;
    private String groupId;

    public AmazonEC2DeleteSecurityGroupTask() {
        this.setDescription("Delete security group.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void authorizeIngress() {
        String groupName = this.getGroupName();
        String groupId = this.getGroupId();
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        if (groupName == null && groupId == null) {
            throw new GradleException("groupName nor groupId is not specified");
        }
        try {
            ec2.deleteSecurityGroup(new DeleteSecurityGroupRequest().withGroupId(groupId).withGroupName(groupName));
        }
        catch (AmazonServiceException e) {
            if (e.getErrorCode().equals("InvalidPermission.Duplicate")) {
                this.getLogger().warn(e.getMessage());
            }
            throw e;
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
}

