/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2CreateSecurityGroupTask
extends ConventionTask {
    private String groupName;
    private String groupDescription;
    private CreateSecurityGroupResult createSecurityGroupResult;

    public AmazonEC2CreateSecurityGroupTask() {
        this.setDescription("Create security group.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void authorizeIngress() {
        String groupName = this.getGroupName();
        String groupDescription = this.getGroupDescription();
        if (groupName == null) {
            throw new GradleException("groupName is not specified");
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        try {
            this.createSecurityGroupResult = ec2.createSecurityGroup(new CreateSecurityGroupRequest().withGroupName(groupName).withDescription(groupDescription));
        }
        catch (AmazonServiceException e) {
            if (e.getErrorCode().equals("InvalidPermission.Duplicate")) {
                this.getLogger().warn(e.getMessage());
            }
            throw e;
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public void setGroupDescription(String groupDescription) {
        this.groupDescription = groupDescription;
    }

    public CreateSecurityGroupResult getCreateSecurityGroupResult() {
        return this.createSecurityGroupResult;
    }
}

