/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import jp.classmethod.aws.gradle.ec2.AbstractAmazonEC2SecurityGroupPermissionTask;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2AuthorizeSecurityGroupIngressTask
extends AbstractAmazonEC2SecurityGroupPermissionTask {
    private String groupId;
    private String groupName;
    private Object ipPermissions;

    public AmazonEC2AuthorizeSecurityGroupIngressTask() {
        this.setDescription("Authorize security group ingress.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void authorizeIngress() {
        String groupId = this.getGroupId();
        String groupName = this.getGroupName();
        Object ipPermissions = this.getIpPermissions();
        if (groupId == null && groupName == null) {
            throw new GradleException("groupId nor groupName is not specified");
        }
        if (ipPermissions == null) {
            throw new GradleException("ipPermissions is not specified");
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        try {
            ec2.authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId(groupId).withGroupName(groupName).withIpPermissions(this.parse(ipPermissions)));
        }
        catch (AmazonServiceException e) {
            if (e.getErrorCode().equals("InvalidPermission.Duplicate")) {
                this.getLogger().warn(e.getMessage());
            }
            throw e;
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Object getIpPermissions() {
        return this.ipPermissions;
    }

    public void setIpPermissions(Object ipPermissions) {
        this.ipPermissions = ipPermissions;
    }
}

