/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import jp.classmethod.aws.gradle.ec2.AbstractAmazonEC2SecurityGroupPermissionTask;
import jp.classmethod.aws.gradle.ec2.AmazonEC2PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class AmazonEC2AuthorizeSecurityGroupEgressTask
extends AbstractAmazonEC2SecurityGroupPermissionTask {
    private String groupId;
    private Object ipPermissions;

    public AmazonEC2AuthorizeSecurityGroupEgressTask() {
        this.setDescription("Authorize security group ingress.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void authorizeEgress() {
        String groupId = this.getGroupId();
        Object ipPermissions = this.getIpPermissions();
        if (groupId == null) {
            throw new GradleException("groupId is not specified");
        }
        if (ipPermissions == null) {
            throw new GradleException("ipPermissions is not specified");
        }
        AmazonEC2PluginExtension ext = (AmazonEC2PluginExtension)this.getProject().getExtensions().getByType(AmazonEC2PluginExtension.class);
        AmazonEC2 ec2 = (AmazonEC2)ext.getClient();
        try {
            ec2.authorizeSecurityGroupEgress(new AuthorizeSecurityGroupEgressRequest().withGroupId(groupId).withIpPermissions(this.parse(ipPermissions)));
        }
        catch (AmazonServiceException e) {
            if (e.getErrorCode().equals("InvalidPermission.Duplicate")) {
                this.getLogger().warn(e.getMessage());
            }
            throw e;
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Object getIpPermissions() {
        return this.ipPermissions;
    }

    public void setIpPermissions(Object ipPermissions) {
        this.ipPermissions = ipPermissions;
    }
}

