/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.common;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import java.util.concurrent.atomic.AtomicReference;
import jp.classmethod.aws.gradle.AwsPluginExtension;
import org.gradle.api.Nullable;
import org.gradle.api.Project;

public abstract class BasePluginExtension<T extends AmazonWebServiceClient> {
    private final Class<T> awsClientClass;
    private Project project;
    private String profileName;
    private final AtomicReference<Object> client = new AtomicReference();

    public BasePluginExtension(Project project, Class<T> awsClientClass) {
        this.project = project;
        this.awsClientClass = awsClientClass;
    }

    protected T initClient() {
        AwsPluginExtension aws = (AwsPluginExtension)this.project.getExtensions().getByType(AwsPluginExtension.class);
        return aws.createClient(this.awsClientClass, this.profileName, this.buildClientConfiguration());
    }

    @Nullable
    protected ClientConfiguration buildClientConfiguration() {
        return null;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getClient() {
        Object value = this.client.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.client;
            synchronized (atomicReference) {
                value = this.client.get();
                if (value == null) {
                    T actualValue = this.initClient();
                    value = actualValue == null ? this.client : actualValue;
                    this.client.set(value);
                }
            }
        }
        return (T)((AmazonWebServiceClient)(value == this.client ? null : value));
    }
}

