/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudwatch;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.Metric;
import java.util.List;
import jp.classmethod.aws.gradle.cloudwatch.AwsCloudWatchPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AwsCloudWatchListMetricsTask
extends ConventionTask {
    private String metricName;
    private String namespace;
    private List<Metric> metrics;

    public AwsCloudWatchListMetricsTask() {
        this.setDescription("List CloudWatch metrics.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void listMetrics() {
        AwsCloudWatchPluginExtension ext = (AwsCloudWatchPluginExtension)this.getProject().getExtensions().getByType(AwsCloudWatchPluginExtension.class);
        AmazonCloudWatch cw = (AmazonCloudWatch)ext.getClient();
        try {
            ListMetricsRequest request = new ListMetricsRequest().withMetricName(this.getMetricName()).withNamespace(this.getNamespace());
            boolean done = false;
            while (!done) {
                ListMetricsResult response = cw.listMetrics(request);
                if (this.getMetrics() == null) {
                    this.metrics = response.getMetrics();
                } else {
                    this.metrics.addAll(response.getMetrics());
                }
                for (Metric metric : response.getMetrics()) {
                    this.getLogger().debug("Retrieved metric %s", (Object)metric.getMetricName());
                }
                request.setNextToken(response.getNextToken());
                if (response.getNextToken() != null) continue;
                done = true;
            }
        }
        catch (AmazonServiceException e) {
            throw new GradleException("Fail to describe metric: " + this.getMetricName(), (Throwable)e);
        }
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }
}

