/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.StackEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;

public abstract class StatusWaiter {
    protected final AmazonCloudFormation cfn;
    protected final String stackName;
    protected final Logger logger;
    private final int loopTimeout;
    private final int loopWait;

    public abstract GetStatusResult getStatus();

    public abstract String describeSubject();

    protected StatusWaiter(AmazonCloudFormation cfn, String stackName, Logger logger, int loopTimeout, int loopWait) {
        this.cfn = cfn;
        this.stackName = stackName;
        this.logger = logger;
        this.loopTimeout = loopTimeout;
        this.loopWait = loopWait;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForSuccessStatus() throws InterruptedException {
        long start = System.currentTimeMillis();
        boolean found = false;
        ArrayList<String> printedEvents = new ArrayList<String>();
        while (true) {
            if (System.currentTimeMillis() > start + (long)(this.loopTimeout * 1000)) {
                throw new GradleException("Timeout");
            }
            try {
                GetStatusResult lastStatus = this.getStatus();
                found = true;
                List<StackEvent> stackEvents = this.getStackEvents(this.stackName);
                this.printEvents(stackEvents, printedEvents);
                if (lastStatus == GetStatusResult.SUCCESS) {
                    this.logger.info("Status of {} is now {}.", (Object)this.describeSubject(), (Object)lastStatus);
                    return;
                }
                if (lastStatus != GetStatusResult.WAITING) throw new GradleException("Status of " + this.describeSubject() + " is " + (Object)((Object)lastStatus) + ".  It seems to be failed.");
                this.logger.info("Status of {} is {}...", (Object)this.describeSubject(), (Object)lastStatus);
                Thread.sleep(this.loopWait * 1000);
            }
            catch (AmazonServiceException e) {
                if (found) {
                    return;
                }
                throw new GradleException(String.format(Locale.ENGLISH, "Failed to get status for %s: ", this.describeSubject()), (Throwable)e);
            }
        }
    }

    private List<StackEvent> getStackEvents(String stackName) {
        DescribeStackEventsRequest request = new DescribeStackEventsRequest().withStackName(stackName);
        DescribeStackEventsResult result = this.cfn.describeStackEvents(request);
        LinkedList<StackEvent> stackEvents = new LinkedList<StackEvent>(result.getStackEvents());
        Collections.reverse(stackEvents);
        return stackEvents;
    }

    private void printEvents(List<StackEvent> stackEvents, List<String> printedEvents) {
        if (printedEvents.isEmpty()) {
            this.logger.info("==== Events ====");
        }
        stackEvents.stream().forEach(o -> {
            String eventId = o.getEventId();
            if (!printedEvents.contains(eventId)) {
                this.logger.info("{} {} {}: {} {}", new Object[]{o.getTimestamp(), o.getResourceStatus(), o.getResourceType(), o.getLogicalResourceId(), o.getResourceStatusReason() == null ? "" : o.getResourceStatusReason()});
                printedEvents.add(eventId);
            }
        });
    }

    public static enum GetStatusResult {
        SUCCESS,
        FAILURE,
        WAITING;

    }
}

