/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import java.util.Arrays;
import java.util.List;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import jp.classmethod.aws.gradle.cloudformation.StackStatusWaiter;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationWaitStackStatusTask
extends ConventionTask {
    private String stackName;
    private List<String> successStatuses = Arrays.asList("CREATE_COMPLETE", "UPDATE_COMPLETE", "DELETE_COMPLETE");
    private List<String> waitStatuses = Arrays.asList("CREATE_IN_PROGRESS", "ROLLBACK_IN_PROGRESS", "DELETE_IN_PROGRESS", "UPDATE_IN_PROGRESS", "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS", "UPDATE_ROLLBACK_IN_PROGRESS", "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS");
    private int loopTimeout = 900;
    private int loopWait = 10;

    public AmazonCloudFormationWaitStackStatusTask() {
        this.setDescription("Wait cfn stack for specific status.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void waitStackForStatus() throws InterruptedException {
        String stackName = this.getStackName();
        List<String> successStatuses = this.getSuccessStatuses();
        List<String> waitStatuses = this.getWaitStatuses();
        int loopTimeout = this.getLoopTimeout();
        int loopWait = this.getLoopWait();
        if (stackName == null) {
            throw new GradleException("stackName is not specified");
        }
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
        StackStatusWaiter stackStatusWaiter = new StackStatusWaiter(cfn, stackName, this.getLogger(), successStatuses, waitStatuses, loopTimeout, loopWait);
        stackStatusWaiter.waitForSuccessStatus();
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public List<String> getSuccessStatuses() {
        return this.successStatuses;
    }

    public void setSuccessStatuses(List<String> successStatuses) {
        this.successStatuses = successStatuses;
    }

    public List<String> getWaitStatuses() {
        return this.waitStatuses;
    }

    public void setWaitStatuses(List<String> waitStatuses) {
        this.waitStatuses = waitStatuses;
    }

    public int getLoopTimeout() {
        return this.loopTimeout;
    }

    public void setLoopTimeout(int loopTimeout) {
        this.loopTimeout = loopTimeout;
    }

    public int getLoopWait() {
        return this.loopWait;
    }

    public void setLoopWait(int loopWait) {
        this.loopWait = loopWait;
    }
}

