/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationMigrateStackTask
extends ConventionTask {
    private String stackName;
    private String cfnTemplateUrl;
    private File cfnTemplateFile;
    private List<Parameter> cfnStackParams = new ArrayList<Parameter>();
    private List<Tag> cfnStackTags = new ArrayList<Tag>();
    private boolean capabilityIam;
    private Capability useCapabilityIam;
    private String cfnStackPolicyUrl;
    private File cfnStackPolicyFile;
    private String cfnOnFailure;
    private List<String> stableStatuses = Arrays.asList("CREATE_COMPLETE", "ROLLBACK_COMPLETE", "UPDATE_COMPLETE", "UPDATE_ROLLBACK_COMPLETE");

    public AmazonCloudFormationMigrateStackTask() {
        this.setDescription("Create / Migrate cfn stack.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createOrUpdateStack() throws InterruptedException, IOException {
        block8: {
            String stackName = this.getStackName();
            String cfnTemplateUrl = this.getCfnTemplateUrl();
            File cfnTemplateFile = this.getCfnTemplateFile();
            List<String> stableStatuses = this.getStableStatuses();
            if (stackName == null) {
                throw new GradleException("stackName is not specified");
            }
            AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
            AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
            try {
                DescribeStacksResult describeStackResult = cfn.describeStacks(new DescribeStacksRequest().withStackName(stackName));
                Stack stack = (Stack)describeStackResult.getStacks().get(0);
                if (stack.getStackStatus().equals("DELETE_COMPLETE")) {
                    this.getLogger().warn("deleted stack {} already exists", (Object)stackName);
                    this.deleteStack(cfn);
                    this.createStack(cfn);
                    break block8;
                }
                if (stableStatuses.contains(stack.getStackStatus())) {
                    this.updateStack(cfn);
                    break block8;
                }
                throw new GradleException("invalid status for update: " + stack.getStackStatus());
            }
            catch (AmazonServiceException e) {
                if (e.getMessage().contains("does not exist")) {
                    this.getLogger().warn("stack {} not found", (Object)stackName);
                    if (cfnTemplateUrl == null && cfnTemplateFile == null) {
                        this.getLogger().error("cfnTemplateUrl or cfnTemplateFile must be provided");
                        throw e;
                    }
                    this.createStack(cfn);
                }
                if (e.getMessage().contains("No updates are to be performed.")) {
                    this.getLogger().trace(e.getMessage());
                }
                throw e;
            }
        }
    }

    private void updateStack(AmazonCloudFormation cfn) throws IOException {
        String stackName = this.getStackName();
        String cfnTemplateUrl = this.getCfnTemplateUrl();
        File cfnTemplateFile = this.getCfnTemplateFile();
        List<Parameter> cfnStackParams = this.getCfnStackParams();
        List<Tag> cfnStackTags = this.getCfnStackTags();
        String cfnStackPolicyUrl = this.getCfnStackPolicyUrl();
        File cfnStackPolicyFile = this.getCfnStackPolicyFile();
        this.getLogger().info("Update stack: {}", (Object)stackName);
        this.getLogger().info("==== Parameters ====");
        cfnStackParams.stream().forEach(p -> this.getLogger().info("{} = {}", (Object)p.getParameterKey(), (Object)p.getParameterValue()));
        UpdateStackRequest req = new UpdateStackRequest().withStackName(stackName).withParameters(cfnStackParams).withTags(cfnStackTags);
        if (!Strings.isNullOrEmpty((String)cfnTemplateUrl)) {
            req.setTemplateURL(cfnTemplateUrl);
            this.getLogger().info("Using template url: {}", (Object)cfnTemplateUrl);
        } else if (cfnTemplateFile != null) {
            req.setTemplateBody(FileUtils.readFileToString((File)cfnTemplateFile));
            this.getLogger().info("Using template file: {}", (Object)"$cfnTemplateFile.canonicalPath");
        } else {
            req.setUsePreviousTemplate(Boolean.valueOf(true));
            this.getLogger().info("No template specified, updating existing template");
        }
        if (this.isCapabilityIam()) {
            Capability selectedCapability = this.getUseCapabilityIam() == null ? Capability.CAPABILITY_IAM : this.getUseCapabilityIam();
            this.getLogger().info("Using IAM capability: " + selectedCapability);
            req.setCapabilities(Arrays.asList(selectedCapability.toString()));
        }
        if (!Strings.isNullOrEmpty((String)cfnStackPolicyUrl)) {
            req.setStackPolicyURL(cfnStackPolicyUrl);
        } else if (cfnStackPolicyFile != null) {
            req.setStackPolicyBody(FileUtils.readFileToString((File)cfnStackPolicyFile));
        }
        UpdateStackResult updateStackResult = cfn.updateStack(req);
        this.getLogger().info("Update requested: {}", (Object)updateStackResult.getStackId());
    }

    private void deleteStack(AmazonCloudFormation cfn) throws InterruptedException {
        String stackName = this.getStackName();
        this.getLogger().info("delete stack: {}", (Object)stackName);
        cfn.deleteStack(new DeleteStackRequest().withStackName(stackName));
        this.getLogger().info("delete requested: {}", (Object)stackName);
        Thread.sleep(3000L);
    }

    private void createStack(AmazonCloudFormation cfn) throws IOException {
        String stackName = this.getStackName();
        String cfnTemplateUrl = this.getCfnTemplateUrl();
        File cfnTemplateFile = this.getCfnTemplateFile();
        List<Parameter> cfnStackParams = this.getCfnStackParams();
        List<Tag> cfnStackTags = this.getCfnStackTags();
        String cfnStackPolicyUrl = this.getCfnStackPolicyUrl();
        File cfnStackPolicyFile = this.getCfnStackPolicyFile();
        String cfnOnFailure = this.getCfnOnFailure();
        this.getLogger().info("create stack: {}", (Object)stackName);
        this.getLogger().info("==== Parameters ====");
        cfnStackParams.stream().forEach(p -> this.getLogger().info("{} = {}", (Object)p.getParameterKey(), (Object)p.getParameterValue()));
        CreateStackRequest req = new CreateStackRequest().withStackName(stackName).withParameters(cfnStackParams).withTags(cfnStackTags).withOnFailure(cfnOnFailure);
        if (!Strings.isNullOrEmpty((String)cfnTemplateUrl)) {
            req.setTemplateURL(cfnTemplateUrl);
        } else {
            req.setTemplateBody(FileUtils.readFileToString((File)cfnTemplateFile));
        }
        if (this.isCapabilityIam()) {
            Capability selectedCapability = this.getUseCapabilityIam() == null ? Capability.CAPABILITY_IAM : this.getUseCapabilityIam();
            this.getLogger().info("Using IAM capability: " + selectedCapability);
            req.setCapabilities(Arrays.asList(selectedCapability.toString()));
        }
        if (!Strings.isNullOrEmpty((String)cfnStackPolicyUrl)) {
            req.setStackPolicyURL(cfnStackPolicyUrl);
        } else if (cfnStackPolicyFile != null) {
            req.setStackPolicyBody(FileUtils.readFileToString((File)cfnStackPolicyFile));
        }
        CreateStackResult createStackResult = cfn.createStack(req);
        this.getLogger().info("create requested: {}", (Object)createStackResult.getStackId());
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getCfnTemplateUrl() {
        return this.cfnTemplateUrl;
    }

    public void setCfnTemplateUrl(String cfnTemplateUrl) {
        this.cfnTemplateUrl = cfnTemplateUrl;
    }

    public File getCfnTemplateFile() {
        return this.cfnTemplateFile;
    }

    public void setCfnTemplateFile(File cfnTemplateFile) {
        this.cfnTemplateFile = cfnTemplateFile;
    }

    public List<Parameter> getCfnStackParams() {
        return this.cfnStackParams;
    }

    public void setCfnStackParams(List<Parameter> cfnStackParams) {
        this.cfnStackParams = cfnStackParams;
    }

    public List<Tag> getCfnStackTags() {
        return this.cfnStackTags;
    }

    public void setCfnStackTags(List<Tag> cfnStackTags) {
        this.cfnStackTags = cfnStackTags;
    }

    public boolean isCapabilityIam() {
        return this.capabilityIam;
    }

    public void setCapabilityIam(boolean capabilityIam) {
        this.capabilityIam = capabilityIam;
    }

    public Capability getUseCapabilityIam() {
        return this.useCapabilityIam;
    }

    public void setUseCapabilityIam(Capability useCapabilityIam) {
        this.useCapabilityIam = useCapabilityIam;
    }

    public String getCfnStackPolicyUrl() {
        return this.cfnStackPolicyUrl;
    }

    public void setCfnStackPolicyUrl(String cfnStackPolicyUrl) {
        this.cfnStackPolicyUrl = cfnStackPolicyUrl;
    }

    public File getCfnStackPolicyFile() {
        return this.cfnStackPolicyFile;
    }

    public void setCfnStackPolicyFile(File cfnStackPolicyFile) {
        this.cfnStackPolicyFile = cfnStackPolicyFile;
    }

    public String getCfnOnFailure() {
        return this.cfnOnFailure;
    }

    public void setCfnOnFailure(String cfnOnFailure) {
        this.cfnOnFailure = cfnOnFailure;
    }

    public List<String> getStableStatuses() {
        return this.stableStatuses;
    }

    public void setStableStatuses(List<String> stableStatuses) {
        this.stableStatuses = stableStatuses;
    }
}

