/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.AmazonCloudFormationException;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.ChangeSetType;
import com.amazonaws.services.cloudformation.model.CreateChangeSetRequest;
import com.amazonaws.services.cloudformation.model.CreateChangeSetResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.Tag;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jp.classmethod.aws.gradle.cloudformation.AmazonCloudFormationPluginExtension;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonCloudFormationCreateChangeSetTask
extends ConventionTask {
    private String stackName;
    private String cfnTemplateUrl;
    private File cfnTemplateFile;
    private List<Parameter> cfnStackParams = new ArrayList<Parameter>();
    private List<Tag> cfnStackTags = new ArrayList<Tag>();
    private String cfnRoleArn;
    private boolean capabilityIam;
    private Capability useCapabilityIam;
    private List<String> stableStatuses = Arrays.asList("CREATE_COMPLETE", "ROLLBACK_COMPLETE", "UPDATE_COMPLETE", "UPDATE_ROLLBACK_COMPLETE", "REVIEW_IN_PROGRESS");

    public AmazonCloudFormationCreateChangeSetTask() {
        this.setDescription("Create cfn change set.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createChangeSet() throws InterruptedException, IOException {
        String stackName = this.getStackName();
        List<String> stableStatuses = this.getStableStatuses();
        if (stackName == null) {
            throw new GradleException("stackName is not specified");
        }
        AmazonCloudFormationPluginExtension ext = (AmazonCloudFormationPluginExtension)this.getProject().getExtensions().getByType(AmazonCloudFormationPluginExtension.class);
        AmazonCloudFormation cfn = (AmazonCloudFormation)ext.getClient();
        try {
            DescribeStacksResult describeStackResult = cfn.describeStacks(new DescribeStacksRequest().withStackName(stackName));
            Stack stack = (Stack)describeStackResult.getStacks().get(0);
            if (!stableStatuses.contains(stack.getStackStatus())) {
                throw new GradleException("invalid status for create change set: " + stack.getStackStatus());
            }
            this.createChangeSet(cfn, ChangeSetType.UPDATE);
        }
        catch (AmazonCloudFormationException e) {
            if (e.getMessage().contains("does not exist")) {
                this.createChangeSet(cfn, ChangeSetType.CREATE);
            }
            throw new GradleException("Failed to describe stack " + stackName, (Throwable)e);
        }
    }

    private void createChangeSet(AmazonCloudFormation cfn, ChangeSetType changeSetType) throws IOException {
        String stackName = this.getStackName();
        String cfnTemplateUrl = this.getCfnTemplateUrl();
        List<Parameter> cfnStackParams = this.getCfnStackParams();
        List<Tag> cfnStackTags = this.getCfnStackTags();
        String cfnRoleArn = this.getCfnRoleArn();
        File cfnTemplateFile = this.getCfnTemplateFile();
        String changeSetName = this.changeSetName(stackName);
        this.getLogger().info("Create change set '{}' for stack '{}'", (Object)changeSetName, (Object)stackName);
        CreateChangeSetRequest req = new CreateChangeSetRequest().withChangeSetName(changeSetName).withStackName(stackName).withParameters(cfnStackParams).withTags(cfnStackTags).withRoleARN(cfnRoleArn).withChangeSetType(changeSetType);
        if (!Strings.isNullOrEmpty((String)cfnTemplateUrl)) {
            req.setTemplateURL(cfnTemplateUrl);
        } else {
            req.setTemplateBody(FileUtils.readFileToString((File)cfnTemplateFile));
        }
        if (this.isCapabilityIam()) {
            Capability selectedCapability = this.getUseCapabilityIam() == null ? Capability.CAPABILITY_IAM : this.getUseCapabilityIam();
            this.getLogger().info("Using IAM capability: " + selectedCapability);
            req.setCapabilities(Arrays.asList(selectedCapability.toString()));
        }
        CreateChangeSetResult createChangeSetResult = cfn.createChangeSet(req);
        this.getLogger().info("Create change set requested: {}", (Object)createChangeSetResult.getId());
    }

    private String changeSetName(String stackName) {
        return stackName + new SimpleDateFormat("-yyyyMMdd-HHmmss", Locale.ENGLISH).format(new Date());
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getCfnTemplateUrl() {
        return this.cfnTemplateUrl;
    }

    public void setCfnTemplateUrl(String cfnTemplateUrl) {
        this.cfnTemplateUrl = cfnTemplateUrl;
    }

    public File getCfnTemplateFile() {
        return this.cfnTemplateFile;
    }

    public void setCfnTemplateFile(File cfnTemplateFile) {
        this.cfnTemplateFile = cfnTemplateFile;
    }

    public List<Parameter> getCfnStackParams() {
        return this.cfnStackParams;
    }

    public void setCfnStackParams(List<Parameter> cfnStackParams) {
        this.cfnStackParams = cfnStackParams;
    }

    public List<Tag> getCfnStackTags() {
        return this.cfnStackTags;
    }

    public void setCfnStackTags(List<Tag> cfnStackTags) {
        this.cfnStackTags = cfnStackTags;
    }

    public String getCfnRoleArn() {
        return this.cfnRoleArn;
    }

    public void setCfnRoleArn(String cfnRoleArn) {
        this.cfnRoleArn = cfnRoleArn;
    }

    public boolean isCapabilityIam() {
        return this.capabilityIam;
    }

    public void setCapabilityIam(boolean capabilityIam) {
        this.capabilityIam = capabilityIam;
    }

    public Capability getUseCapabilityIam() {
        return this.useCapabilityIam;
    }

    public void setUseCapabilityIam(Capability useCapabilityIam) {
        this.useCapabilityIam = useCapabilityIam;
    }

    public List<String> getStableStatuses() {
        return this.stableStatuses;
    }

    public void setStableStatuses(List<String> stableStatuses) {
        this.stableStatuses = stableStatuses;
    }
}

