/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import joinery.DataFrame;
import joinery.impl.js.DataFrameAdapter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class Shell {
    public static Object repl(List<DataFrame<Object>> frames) throws IOException {
        return Shell.repl(System.in, frames);
    }

    public static Object repl(InputStream input, List<DataFrame<Object>> frames) throws IOException {
        return new Repl(input, frames).run();
    }

    private static class Repl
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;
        private static final String PROMPT = "> ";
        private static final String PROMPT_CONTINUE = "  ";
        private static final String LAST_VALUE_NAME = "_";
        private static final String FILENAME = "<shell>";
        private final String NEWLINE = System.getProperty("line.separator");
        private final InputStream input;
        private final List<DataFrame<Object>> frames;
        private final boolean interactive = System.console() != null;
        private transient boolean quit = false;
        private transient int statement = 1;

        private Repl(InputStream input, List<DataFrame<Object>> frames) {
            this.input = input;
            this.frames = frames;
        }

        public String getClassName() {
            return "shell";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws IOException {
            Object result = null;
            Console console = this.console(this.input);
            Context ctx = Context.enter();
            if (this.interactive) {
                Package pkg = DataFrame.class.getPackage();
                System.out.printf("# %s -- %s, %s-%s\n# %s, %s, %s\n# %s\n", pkg.getSpecificationTitle(), pkg.getImplementationTitle(), pkg.getSpecificationVersion(), pkg.getImplementationVersion(), System.getProperty("java.vm.name"), System.getProperty("java.vendor"), System.getProperty("java.version"), ctx.getImplementationVersion());
            }
            try {
                ctx.initStandardObjects((ScriptableObject)this);
                this.defineFunctionProperties(new String[]{"print", "quit", "source"}, ((Object)((Object)this)).getClass(), 2);
                try {
                    ScriptableObject.defineClass((Scriptable)this, DataFrameAdapter.class);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
                for (Class<?> cls : DataFrame.class.getDeclaredClasses()) {
                    this.put(cls.getSimpleName(), (Scriptable)this, new NativeJavaClass((Scriptable)this, cls));
                }
                DataFrameAdapter[] array = new DataFrameAdapter[this.frames.size()];
                for (int i = 0; i < this.frames.size(); ++i) {
                    DataFrame<Object> df = this.frames.get(i);
                    array[i] = new DataFrameAdapter(ctx.newObject((Scriptable)this, df.getClass().getSimpleName()), df);
                }
                this.put("frames", (Scriptable)this, new NativeJavaArray((Scriptable)this, (Object)array));
                String expr = null;
                while (!this.quit && (expr = this.read(console)) != null) {
                    try {
                        result = this.eval(expr);
                        if (result == Context.getUndefinedValue()) continue;
                        this.put(LAST_VALUE_NAME, (Scriptable)this, result);
                        if (!this.interactive) continue;
                        System.out.println(Context.toString((Object)result));
                    }
                    catch (Exception ex) {
                        if (this.interactive) {
                            if (ex instanceof WrappedException) {
                                ((WrappedException)WrappedException.class.cast(ex)).getCause().printStackTrace();
                            } else {
                                ex.printStackTrace();
                            }
                        }
                        result = ex;
                    }
                }
            }
            finally {
                Context.exit();
            }
            return Context.jsToJava(result, Object.class);
        }

        public String read(Console console) throws IOException {
            Context ctx = Context.getCurrentContext();
            StringBuilder buffer = new StringBuilder();
            String line = null;
            line = console.readLine(PROMPT);
            if (line != null) {
                if (line.startsWith(".") && this.has(LAST_VALUE_NAME, (Scriptable)this)) {
                    buffer.append(LAST_VALUE_NAME);
                }
                buffer.append(line);
                while (!ctx.stringIsCompilableUnit(buffer.toString()) && (line = console.readLine(PROMPT_CONTINUE)) != null) {
                    buffer.append(this.NEWLINE).append(line);
                }
                return buffer.toString();
            }
            return null;
        }

        public Object eval(String source) {
            Context ctx = Context.getCurrentContext();
            return ctx.evaluateString((Scriptable)this, source, FILENAME, this.statement++, null);
        }

        public static void print(Context ctx, Scriptable object, Object[] args, Function func) {
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(Context.toString((Object)args[i]));
            }
            System.out.println();
        }

        public void quit() {
            this.quit = true;
        }

        public static void source(Context ctx, Scriptable object, Object[] args, Function func) throws Exception {
            Repl repl = (Repl)((Object)Repl.class.cast(object));
            for (int i = 0; i < args.length; ++i) {
                String file = Context.toString((Object)args[i]);
                Repl repl2 = repl;
                ((Object)((Object)repl2)).getClass();
                SourceReader source = repl2.new SourceReader(file);
                String expr = null;
                while ((expr = repl.read(source)) != null) {
                    Object result = repl.eval(expr);
                    if (result == Context.getUndefinedValue()) continue;
                    repl.put(LAST_VALUE_NAME, (Scriptable)repl, result);
                    if (!repl.interactive) continue;
                    System.out.println(Context.toString((Object)result));
                }
            }
        }

        private Console console(InputStream input) throws IOException {
            if (this.interactive) {
                try {
                    return new JLineConsole();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            return new Console(new BufferedReader(new InputStreamReader(input)));
        }

        private class JLineConsole
        extends Console
        implements Runnable,
        Completer {
            private final ConsoleReader console;

            private JLineConsole() throws IOException {
                this.console = new ConsoleReader();
                this.console.addCompleter((Completer)this);
                this.console.setExpandEvents(false);
                Runtime.getRuntime().addShutdownHook(new Thread(this));
            }

            @Override
            public String readLine(String prompt) throws IOException {
                this.console.setPrompt(prompt);
                return this.console.readLine();
            }

            @Override
            public void run() {
                try {
                    this.console.getTerminal().restore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public int complete(String buffer, int cursor, List<CharSequence> candidates) {
                String expr = buffer.substring(buffer.lastIndexOf(32) + 1);
                int dot = expr.lastIndexOf(46) + 1;
                if (dot > 1) {
                    String var = expr.substring(0, dot - 1);
                    String prefix = expr.substring(dot);
                    Object value = Repl.this.get(var, (Scriptable)Repl.this);
                    if (value != Scriptable.NOT_FOUND) {
                        if (value instanceof ScriptableObject) {
                            Object[] ids = ((ScriptableObject)ScriptableObject.class.cast(value)).getAllIds();
                            Arrays.sort(ids);
                            for (Object id : ids) {
                                if (!(id instanceof String) || !((String)String.class.cast(id)).startsWith(prefix)) continue;
                                candidates.add((CharSequence)String.class.cast(id));
                            }
                        }
                        if (!candidates.isEmpty()) {
                            return dot;
                        }
                    }
                }
                return buffer.length();
            }
        }

        private class SourceReader
        extends Console {
            private SourceReader(String file) throws IOException {
                super(new BufferedReader(new FileReader(file)));
            }

            @Override
            public String readLine(String prompt) throws IOException {
                String line = super.readLine("");
                if (Repl.this.interactive && line != null) {
                    System.out.printf("%s%s\n", prompt, line, Repl.this.NEWLINE);
                }
                return line;
            }
        }

        private class Console {
            private final BufferedReader reader;

            private Console() throws IOException {
                this.reader = null;
            }

            private Console(BufferedReader reader) throws IOException {
                this.reader = reader;
            }

            public String readLine(String prompt) throws IOException {
                if (Repl.this.interactive) {
                    System.out.print(prompt);
                }
                return this.reader.readLine();
            }
        }
    }
}

