/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import joinery.DataFrame;

public class Shaping {
    public static final <V> DataFrame<V> reshape(DataFrame<V> df, int rows, int cols) {
        Object name;
        int c;
        DataFrame<Object> reshaped = new DataFrame<Object>();
        Iterator<Object> it = df.columns().iterator();
        for (c = 0; c < cols; ++c) {
            name = it.hasNext() ? it.next() : Integer.valueOf(c);
            reshaped.add(name);
        }
        it = df.index().iterator();
        for (int r = 0; r < rows; ++r) {
            name = it.hasNext() ? it.next() : Integer.valueOf(r);
            reshaped.append(name, Collections.emptyList());
        }
        for (c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                if (c >= df.size() || r >= df.length()) continue;
                reshaped.set(r, c, df.get(r, c));
            }
        }
        return reshaped;
    }

    public static final <V> DataFrame<V> reshape(DataFrame<V> df, Collection<?> rows, Collection<?> cols) {
        DataFrame<Object> reshaped = new DataFrame<Object>();
        for (Object name : cols) {
            reshaped.add(name);
        }
        for (Object name : rows) {
            reshaped.append(name, Collections.emptyList());
        }
        for (Object c : cols) {
            for (Object r : rows) {
                if (!df.columns().contains(c) || !df.index().contains(r)) continue;
                reshaped.set(r, c, df.get(r, c));
            }
        }
        return reshaped;
    }
}

