/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import com.xeiam.xchart.Chart;
import com.xeiam.xchart.ChartBuilder;
import com.xeiam.xchart.Series;
import com.xeiam.xchart.SeriesLineStyle;
import com.xeiam.xchart.SeriesMarker;
import com.xeiam.xchart.StyleManager;
import com.xeiam.xchart.XChartPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import joinery.DataFrame;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public class Display {
    public static <V> void plot(final DataFrame<V> df, DataFrame.PlotType type) {
        final LinkedList<XChartPanel> panels = new LinkedList<XChartPanel>();
        DataFrame<Number> numeric = df.numeric().fillna(0);
        final int rows = (int)Math.ceil(Math.sqrt(numeric.size()));
        final int cols = numeric.size() / rows + 1;
        ArrayList<Object> xdata = new ArrayList<Object>(df.length());
        Iterator<Object> it = df.index().iterator();
        for (int i = 0; i < df.length(); ++i) {
            Object value;
            Object object = value = it.hasNext() ? it.next() : Integer.valueOf(i);
            if (value instanceof Number || value instanceof Date) {
                xdata.add(value);
                continue;
            }
            if (DataFrame.PlotType.BAR.equals((Object)type)) {
                xdata.add(String.valueOf(value));
                continue;
            }
            xdata.add(i);
        }
        if (EnumSet.of(DataFrame.PlotType.GRID, DataFrame.PlotType.GRID_WITH_TREND).contains((Object)type)) {
            for (Object col : numeric.columns()) {
                Chart chart = new ChartBuilder().chartType(Display.chartType(type)).width(800 / cols).height(800 / cols).title(String.valueOf(col)).build();
                Series series = chart.addSeries(String.valueOf(col), xdata, numeric.col(col));
                if (type == DataFrame.PlotType.GRID_WITH_TREND) {
                    Display.addTrend(chart, series, xdata);
                    series.setLineStyle(SeriesLineStyle.NONE);
                }
                chart.getStyleManager().setLegendVisible(false);
                chart.getStyleManager().setDatePattern(Display.dateFormat(xdata));
                panels.add(new XChartPanel(chart));
            }
        } else {
            Chart chart = new ChartBuilder().chartType(Display.chartType(type)).build();
            chart.getStyleManager().setDatePattern(Display.dateFormat(xdata));
            switch (type) {
                case SCATTER: 
                case SCATTER_WITH_TREND: 
                case LINE_AND_POINTS: {
                    break;
                }
                default: {
                    chart.getStyleManager().setMarkerSize(0);
                }
            }
            for (Object col : numeric.columns()) {
                Series series = chart.addSeries(String.valueOf(col), xdata, numeric.col(col));
                if (type != DataFrame.PlotType.SCATTER_WITH_TREND) continue;
                Display.addTrend(chart, series, xdata);
                series.setLineStyle(SeriesLineStyle.NONE);
            }
            panels.add(new XChartPanel(chart));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame(Display.title(df));
                frame.setDefaultCloseOperation(2);
                if (panels.size() > 1) {
                    frame.setLayout(new GridLayout(rows, cols));
                }
                for (XChartPanel p : panels) {
                    frame.add((Component)p);
                }
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public static <V> void show(final DataFrame<V> df) {
        final ArrayList<Object> columns = new ArrayList<Object>(df.columns());
        final List<Class<?>> types = df.types();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame(Display.title(df));
                JTable table = new JTable(new AbstractTableModel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public int getRowCount() {
                        return df.length();
                    }

                    @Override
                    public int getColumnCount() {
                        return df.size();
                    }

                    @Override
                    public Object getValueAt(int row, int col) {
                        return df.get(row, col);
                    }

                    @Override
                    public String getColumnName(int col) {
                        return String.valueOf(columns.get(col));
                    }

                    @Override
                    public Class<?> getColumnClass(int col) {
                        return (Class)types.get(col);
                    }
                });
                table.setAutoResizeMode(0);
                frame.setDefaultCloseOperation(2);
                frame.add(new JScrollPane(table));
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static StyleManager.ChartType chartType(DataFrame.PlotType type) {
        switch (type) {
            case AREA: {
                return StyleManager.ChartType.Area;
            }
            case BAR: {
                return StyleManager.ChartType.Bar;
            }
            case SCATTER: 
            case GRID: {
                return StyleManager.ChartType.Scatter;
            }
        }
        return StyleManager.ChartType.Line;
    }

    private static final String title(DataFrame<?> df) {
        return String.format("%s (%d rows x %d columns)", df.getClass().getCanonicalName(), df.length(), df.size());
    }

    private static final String dateFormat(List<Object> xdata) {
        int[] fields = new int[]{1, 2, 5, 11, 12, 13};
        String[] formats = new String[]{" yyy", "-MMM", "-d", " H", ":mm", ":ss"};
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        if (!xdata.isEmpty() && xdata.get(0) instanceof Date) {
            int i;
            String format = "";
            int first = 0;
            int last = 0;
            c1.setTime((Date)Date.class.cast(xdata.get(0)));
            for (i = 1; i < xdata.size(); ++i) {
                if (!(xdata.get(i) instanceof Date)) {
                    return formats[0].substring(1);
                }
                c2.setTime((Date)Date.class.cast(xdata.get(i)));
                for (int j = 1; j < fields.length; ++j) {
                    if (c1.get(fields[j]) == c2.get(fields[j])) continue;
                    first = Math.max(j - 1, first);
                    last = Math.max(j, last);
                }
            }
            for (i = first; i <= last && i < formats.length; ++i) {
                format = format + (format.isEmpty() ? formats[i].substring(1) : formats[i]);
            }
            return format;
        }
        return formats[0].substring(1);
    }

    private static void addTrend(Chart chart, Series series, List<Object> xdata) {
        SimpleRegression model = new SimpleRegression();
        Iterator y = series.getYData().iterator();
        int x = 0;
        while (y.hasNext()) {
            model.addData((double)x, ((Number)y.next()).doubleValue());
            ++x;
        }
        Color mc = series.getMarkerColor();
        Color c = new Color(mc.getRed(), mc.getGreen(), mc.getBlue(), 96);
        Series trend = chart.addSeries(series.getName() + " (trend)", Arrays.asList(xdata.get(0), xdata.get(xdata.size() - 1)), Arrays.asList(model.predict(0.0), model.predict((double)(xdata.size() - 1))));
        trend.setLineColor(c);
        trend.setMarker(SeriesMarker.NONE);
    }
}

