/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import joinery.DataFrame;

public class Conversion {
    public static <V> void convert(DataFrame<V> df) {
        Conversion.convert(df, DataFrame.NumberDefault.LONG_DEFAULT, null);
    }

    public static <V> void convert(DataFrame<V> df, DataFrame.NumberDefault numDefault, String naString) {
        List<DataFrame.Function> converters;
        HashMap conversions = new HashMap();
        int rows = df.length();
        int cols = df.size();
        switch (numDefault) {
            case LONG_DEFAULT: {
                converters = Arrays.asList(new LongConversion(), new DoubleConversion(), new BooleanConversion(), new DateTimeConversion());
                break;
            }
            case DOUBLE_DEFAULT: {
                converters = Arrays.asList(new DoubleConversion(), new LongConversion(), new BooleanConversion(), new DateTimeConversion());
                break;
            }
            default: {
                throw new IllegalArgumentException("Number default contains an Illegal value");
            }
        }
        NAConversion<V> naConverter = new NAConversion<V>(naString);
        block4: for (int c = 0; c < cols; ++c) {
            for (DataFrame.Function conv : converters) {
                boolean all = true;
                for (int r = 0; r < rows; ++r) {
                    if (conv.apply(df.get(r, c)) != null || naConverter.apply(df.get(r, c)) == null) continue;
                    all = false;
                    break;
                }
                if (!all) continue;
                conversions.put(c, conv);
                continue block4;
            }
        }
        Conversion.convert(df, conversions, naString);
    }

    @SafeVarargs
    public static <V> void convert(DataFrame<V> df, Class<? extends V> ... columnTypes) {
        HashMap conversions = new HashMap();
        for (int i = 0; i < columnTypes.length; ++i) {
            Class<V> cls = columnTypes[i];
            if (cls == null) continue;
            DataFrame.Function conv = null;
            if (Date.class.isAssignableFrom(cls)) {
                conv = new DateTimeConversion();
            } else if (Boolean.class.isAssignableFrom(cls)) {
                conv = new BooleanConversion();
            } else if (Long.class.isAssignableFrom(cls)) {
                conv = new LongConversion();
            } else if (Number.class.isAssignableFrom(cls)) {
                conv = new DoubleConversion();
            } else if (String.class.isAssignableFrom(cls)) {
                conv = new StringConversion();
            }
            conversions.put(i, conv);
        }
        Conversion.convert(df, conversions, null);
    }

    public static <V> void convert(DataFrame<V> df, Map<Integer, DataFrame.Function<V, ?>> conversions, String naString) {
        int rows = df.length();
        int cols = df.size();
        for (int c = 0; c < cols; ++c) {
            DataFrame.Function<V, ?> conv = conversions.get(c);
            if (conv != null) {
                for (int r = 0; r < rows; ++r) {
                    df.set(r, c, conv.apply(df.get(r, c)));
                }
                continue;
            }
            NAConversion<V> naConverter = new NAConversion<V>(naString);
            for (int r = 0; r < rows; ++r) {
                df.set(r, c, naConverter.apply(df.get(r, c)));
            }
        }
    }

    public static <V> double[][] toModelMatrix(DataFrame<V> df, double fillValue) {
        return Conversion.toModelMatrixDataFrame(df).fillna(fillValue).toArray(double[][].class);
    }

    public static <V> double[][] toModelMatrix(DataFrame<V> df, double fillValue, boolean addIntercept) {
        return Conversion.toModelMatrixDataFrame(df, null, addIntercept).fillna(fillValue).toArray(double[][].class);
    }

    public static <V> double[][] toModelMatrix(DataFrame<V> df, double fillValue, DataFrame<Object> template) {
        return Conversion.toModelMatrixDataFrame(df, template, false).fillna(fillValue).toArray(double[][].class);
    }

    public static <V> double[][] toModelMatrix(DataFrame<V> df, double fillValue, DataFrame<Object> template, boolean addIntercept) {
        return Conversion.toModelMatrixDataFrame(df, template, addIntercept).fillna(fillValue).toArray(double[][].class);
    }

    public static <V> DataFrame<Number> toModelMatrixDataFrame(DataFrame<V> df) {
        return Conversion.toModelMatrixDataFrame(df, null, false);
    }

    public static <V> DataFrame<Number> toModelMatrixDataFrame(DataFrame<V> df, DataFrame<Object> template, boolean addIntercept) {
        DataFrame<Number> newDf = new DataFrame<Number>();
        if (addIntercept) {
            newDf.add("DFMMAddedIntercept");
            for (int i = 0; i < df.length(); ++i) {
                newDf.append(Arrays.asList(1.0));
            }
        }
        ArrayList<Object> columns = new ArrayList<Object>(df.columns());
        List<Class<?>> colTypes = df.types();
        for (int i = 0; i < df.size(); ++i) {
            List<V> col = df.col(i);
            if (Number.class.isAssignableFrom(colTypes.get(i))) {
                ArrayList<Number> nums = new ArrayList<Number>();
                for (V num : col) {
                    nums.add((Number)num);
                }
                newDf.add(columns.get(i), nums);
                continue;
            }
            if (Date.class.isAssignableFrom(colTypes.get(i))) {
                ArrayList<Double> dates = new ArrayList<Double>();
                for (V date : col) {
                    dates.add(new Double(((Date)date).getTime()));
                }
                newDf.add(columns.get(i), dates);
                continue;
            }
            if (Boolean.class.isAssignableFrom(colTypes.get(i))) {
                ArrayList<Double> bools = new ArrayList<Double>();
                for (V tVal : col) {
                    bools.add((Boolean)tVal != false ? 1.0 : 0.0);
                }
                newDf.add(columns.get(i), bools);
                continue;
            }
            if (!String.class.isAssignableFrom(colTypes.get(i))) continue;
            List<Object> extra = template != null ? template.col(i) : null;
            List<List<Number>> variable = Conversion.variableToDummy(col, extra);
            int cnt = 0;
            for (List<Number> var : variable) {
                String name = columns.get(i) + "-dummy" + cnt++;
                newDf.add((Object)name, var);
            }
        }
        return newDf;
    }

    protected static <V> List<List<Number>> variableToDummy(List<V> col, List<Object> extra) {
        ArrayList<List<Number>> result = new ArrayList<List<Number>>();
        TreeSet<V> factors = new TreeSet<V>(col);
        if (extra != null) {
            factors.addAll(new TreeSet<Object>(extra));
        }
        Iterator uniqueIter = factors.iterator();
        for (int u = 0; u < factors.size() - 1; ++u) {
            Object v = uniqueIter.next();
            ArrayList<Double> newDummy = new ArrayList<Double>();
            for (int i = 0; i < col.size(); ++i) {
                if (col.get(i).equals(v)) {
                    newDummy.add(1.0);
                    continue;
                }
                newDummy.add(0.0);
            }
            result.add(newDummy);
        }
        return result;
    }

    public static <V> DataFrame<Boolean> isnull(DataFrame<V> df) {
        return df.apply(new DataFrame.Function<V, Boolean>(){

            @Override
            public Boolean apply(V value) {
                return value == null;
            }
        });
    }

    public static <V> DataFrame<Boolean> notnull(DataFrame<V> df) {
        return df.apply(new DataFrame.Function<V, Boolean>(){

            @Override
            public Boolean apply(V value) {
                return value != null;
            }
        });
    }

    private static final class DateTimeConversion<V>
    implements DataFrame.Function<V, Date> {
        private final List<DateFormat> formats = Arrays.asList(new SimpleDateFormat("y-M-d'T'HH:mm:ssXXX"), new SimpleDateFormat("y-M-d'T'HH:mm:ssZZZ"), new SimpleDateFormat("y-M-d"), new SimpleDateFormat("y-M-d hh:mm a"), new SimpleDateFormat("y-M-d HH:mm"), new SimpleDateFormat("y-M-d hh:mm:ss a"), new SimpleDateFormat("y-M-d HH:mm:ss"), new SimpleDateFormat("y/M/d hh:mm:ss a"), new SimpleDateFormat("y/M/d HH:mm:ss"), new SimpleDateFormat("y/M/d hh:mm a"), new SimpleDateFormat("y/M/d HH:mm"), new SimpleDateFormat("dd-MMM-yy hh.mm.ss.SSS a"), new SimpleDateFormat("dd-MMM-yy hh.mm.ss.SSSSSSSSS a"), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"), DateFormat.getDateTimeInstance(), new SimpleDateFormat("y/M/d"), new SimpleDateFormat("M/d/y hh:mm:ss a"), new SimpleDateFormat("M/d/y HH:mm:ss"), new SimpleDateFormat("M/d/y hh:mm a"), new SimpleDateFormat("M/d/y HH:mm"), new SimpleDateFormat("M/d/y"), DateFormat.getDateInstance());

        private DateTimeConversion() {
        }

        @Override
        public Date apply(V value) {
            String source = String.valueOf(value);
            ParsePosition pp = new ParsePosition(0);
            for (DateFormat format : this.formats) {
                Date dt = format.parse(source, pp);
                if (pp.getIndex() == source.length()) {
                    return dt;
                }
                pp.setIndex(0);
                pp.setErrorIndex(-1);
            }
            return null;
        }
    }

    private static final class BooleanConversion<V>
    implements DataFrame.Function<V, Boolean> {
        private BooleanConversion() {
        }

        @Override
        public Boolean apply(V value) {
            String str = String.valueOf(value);
            if (str.matches("t(r(u(e)?)?)?|y(e(s)?)?")) {
                return new Boolean(true);
            }
            if (str.matches("f(a(l(s(e)?)?)?)?|n(o)?")) {
                return new Boolean(false);
            }
            return null;
        }
    }

    private static final class DoubleConversion<V>
    implements DataFrame.Function<V, Double> {
        private DoubleConversion() {
        }

        @Override
        public Double apply(V value) {
            try {
                return new Double(String.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static final class LongConversion<V>
    implements DataFrame.Function<V, Long> {
        private LongConversion() {
        }

        @Override
        public Long apply(V value) {
            try {
                return new Long(String.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static final class StringConversion<V>
    implements DataFrame.Function<V, String> {
        private StringConversion() {
        }

        @Override
        public String apply(V value) {
            return String.valueOf(value);
        }
    }

    private static class NAConversion<V>
    implements DataFrame.Function<V, V> {
        final String naString;

        public NAConversion(String naString) {
            this.naString = naString;
        }

        @Override
        public V apply(V value) {
            return (V)(this.naString != null && String.valueOf(value).equals(this.naString) ? null : value);
        }
    }
}

