/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import joinery.DataFrame;

public class Combining {
    /*
     * WARNING - void declaration
     */
    public static <V> DataFrame<V> join(DataFrame<V> left, DataFrame<V> right, DataFrame.JoinType how, DataFrame.KeyFunction<V> on) {
        Object key;
        Iterator<Object> leftIt = left.index().iterator();
        Iterator<Object> rightIt = right.index().iterator();
        LinkedHashMap<Object, List> leftMap = new LinkedHashMap<Object, List>();
        LinkedHashMap<Object, List> rightMap = new LinkedHashMap<Object, List>();
        for (List list : left) {
            Object object = leftIt.next();
            key = on == null ? object : on.apply(list);
            if (leftMap.put(key, list) == null) continue;
            throw new IllegalArgumentException("generated key is not unique: " + key);
        }
        for (List list : right) {
            Object object = rightIt.next();
            key = on == null ? object : on.apply(list);
            if (rightMap.put(key, list) == null) continue;
            throw new IllegalArgumentException("generated key is not unique: " + key);
        }
        ArrayList<Object> columns = new ArrayList<Object>(how != DataFrame.JoinType.RIGHT ? left.columns() : right.columns());
        for (Object object : how != DataFrame.JoinType.RIGHT ? right.columns() : left.columns()) {
            void var10_20;
            int index = columns.indexOf(object);
            if (index >= 0) {
                if (object instanceof List) {
                    List l1 = (List)List.class.cast(columns.get(index));
                    l1.add(how != DataFrame.JoinType.RIGHT ? "left" : "right");
                    List l2 = (List)List.class.cast(object);
                    l2.add(how != DataFrame.JoinType.RIGHT ? "right" : "left");
                } else {
                    columns.set(index, String.format("%s_%s", columns.get(index), how != DataFrame.JoinType.RIGHT ? "left" : "right"));
                    String string = String.format("%s_%s", object, how != DataFrame.JoinType.RIGHT ? "right" : "left");
                }
            }
            columns.add(var10_20);
        }
        DataFrame dataFrame = new DataFrame((Collection<?>)columns);
        for (Map.Entry entry : how != DataFrame.JoinType.RIGHT ? leftMap.entrySet() : rightMap.entrySet()) {
            List<Object> row;
            ArrayList<Object> tmp = new ArrayList<Object>((Collection)entry.getValue());
            List<Object> list = row = how != DataFrame.JoinType.RIGHT ? (List<Object>)rightMap.get(entry.getKey()) : (List)leftMap.get(entry.getKey());
            if (row == null && how == DataFrame.JoinType.INNER) continue;
            tmp.addAll(row != null ? row : Collections.nCopies(right.columns().size(), null));
            dataFrame.append(entry.getKey(), tmp);
        }
        if (how == DataFrame.JoinType.OUTER) {
            for (Map.Entry entry : how != DataFrame.JoinType.RIGHT ? rightMap.entrySet() : leftMap.entrySet()) {
                List row = how != DataFrame.JoinType.RIGHT ? (List)leftMap.get(entry.getKey()) : (List)rightMap.get(entry.getKey());
                if (row != null) continue;
                ArrayList<Object> tmp = new ArrayList<Object>(Collections.nCopies(how != DataFrame.JoinType.RIGHT ? left.columns().size() : right.columns().size(), null));
                tmp.addAll((Collection)entry.getValue());
                dataFrame.append(entry.getKey(), tmp);
            }
        }
        return dataFrame;
    }

    public static <V> DataFrame<V> joinOn(DataFrame<V> left, DataFrame<V> right, DataFrame.JoinType how, final Integer ... cols) {
        return Combining.join(left, right, how, new DataFrame.KeyFunction<V>(){

            @Override
            public Object apply(List<V> value) {
                ArrayList key = new ArrayList(cols.length);
                Integer[] integerArray = cols;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int col = integerArray[i];
                    key.add(value.get(col));
                }
                return Collections.unmodifiableList(key);
            }
        });
    }

    public static <V> DataFrame<V> merge(DataFrame<V> left, DataFrame<V> right, DataFrame.JoinType how) {
        LinkedHashSet<Object> intersection = new LinkedHashSet<Object>(left.nonnumeric().columns());
        intersection.retainAll(right.nonnumeric().columns());
        Object[] columns = intersection.toArray(new Object[intersection.size()]);
        return Combining.join(left.reindex(columns), right.reindex(columns), how, null);
    }

    @SafeVarargs
    public static <V> void update(DataFrame<V> dest, boolean overwrite, DataFrame<? extends V> ... others) {
        for (int col = 0; col < dest.size(); ++col) {
            block1: for (int row = 0; row < dest.length(); ++row) {
                if (!overwrite && dest.get(row, col) != null) continue;
                for (DataFrame<V> dataFrame : others) {
                    V value;
                    if (col >= dataFrame.size() || row >= dataFrame.length() || (value = dataFrame.get(row, col)) == null) continue;
                    dest.set(row, col, value);
                    continue block1;
                }
            }
        }
    }
}

