/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    private Address local_addr = null;
    private long timeout = 2000L;
    private int num_msgs = 1;
    final Hashtable suspects = new Hashtable();
    private Thread timer = null;
    private boolean use_icmp = false;
    private InetAddress bind_addr;
    private NetworkInterface intf = null;
    private Method is_reacheable;
    static final String name = "VERIFY_SUSPECT";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("timeout")) != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_msgs")) != null) {
            this.num_msgs = Integer.parseInt(str);
            if (this.num_msgs <= 0) {
                if (this.warn) {
                    this.log.warn((Object)("num_msgs is invalid (" + this.num_msgs + "): setting it to 1"));
                }
                this.num_msgs = 1;
            }
            props.remove("num_msgs");
        }
        if ((str = props.getProperty("use_icmp")) != null) {
            this.use_icmp = Boolean.valueOf(str);
            props.remove("use_icmp");
            try {
                this.is_reacheable = InetAddress.class.getMethod("isReachable", NetworkInterface.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                NoSuchMethodError error = new NoSuchMethodError("didn't find InetAddress.isReachable() method - requires JDK 5 or higher");
                error.initCause(e);
                throw error;
            }
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                if (suspected_mbr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"suspected member is null");
                    }
                    return;
                }
                if (this.local_addr != null && this.local_addr.equals(suspected_mbr)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"I was suspected; ignoring SUSPECT message");
                    }
                    return;
                }
                if (!this.use_icmp) {
                    this.verifySuspect(suspected_mbr);
                } else {
                    this.verifySuspectWithICMP(suspected_mbr);
                }
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(name);
                if (obj == null || !(obj instanceof VerifyHeader)) break;
                VerifyHeader hdr = (VerifyHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"ARE_YOU_DEAD: hdr.from is null");
                            }
                        } else {
                            for (int i = 0; i < this.num_msgs; ++i) {
                                Message rsp = new Message(hdr.from, null, null);
                                rsp.putHeader(name, new VerifyHeader(2, this.local_addr));
                                this.passDown(new Event(1, rsp));
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"I_AM_NOT_DEAD: hdr.from is null");
                            }
                            return;
                        }
                        this.unsuspect(hdr.from);
                        return;
                    }
                }
                return;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.timer != null && Thread.currentThread().equals(this.timer) && this.suspects.size() > 0) {
            long diff = 0L;
            LinkedList<Address> tmp = null;
            Hashtable hashtable = this.suspects;
            synchronized (hashtable) {
                Enumeration e = this.suspects.keys();
                while (e.hasMoreElements()) {
                    Address mbr = (Address)e.nextElement();
                    long val = (Long)this.suspects.get(mbr);
                    long curr_time = System.currentTimeMillis();
                    diff = curr_time - val;
                    if (diff >= this.timeout) {
                        if (this.trace) {
                            this.log.trace((Object)("diff=" + diff + ", mbr " + mbr + " is dead (passing up SUSPECT event)"));
                        }
                        if (tmp == null) {
                            tmp = new LinkedList<Address>();
                        }
                        tmp.add(mbr);
                        this.suspects.remove(mbr);
                        continue;
                    }
                    diff = Math.max(diff, this.timeout - diff);
                }
            }
            if (tmp != null && tmp.size() > 0) {
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    this.passUp(new Event(9, it.next()));
                }
            }
            if (diff <= 0L) continue;
            Util.sleep(diff);
        }
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifySuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        Hashtable hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                return;
            }
            this.suspects.put(mbr, new Long(System.currentTimeMillis()));
        }
        if (this.trace) {
            this.log.trace((Object)("verifying that " + mbr + " is dead"));
        }
        for (int i = 0; i < this.num_msgs; ++i) {
            Message msg = new Message(mbr, null, null);
            msg.putHeader(name, new VerifyHeader(1, this.local_addr));
            this.passDown(new Event(1, msg));
        }
        if (this.timer == null) {
            this.startTimer();
        }
    }

    void verifySuspectWithICMP(Address suspected_mbr) {
        block8: {
            InetAddress host;
            InetAddress inetAddress = host = suspected_mbr instanceof IpAddress ? ((IpAddress)suspected_mbr).getIpAddress() : null;
            if (host == null) {
                throw new IllegalArgumentException("suspected_mbr is not of type IpAddress - FD_ICMP only works with these");
            }
            try {
                if (this.trace) {
                    this.log.trace((Object)("pinging host " + suspected_mbr + " using interface " + this.intf));
                }
                long start = System.currentTimeMillis();
                Boolean rc = (Boolean)this.is_reacheable.invoke((Object)host, this.intf, new Integer(0), new Integer((int)this.timeout));
                long stop = System.currentTimeMillis();
                if (rc.booleanValue()) {
                    if (this.trace) {
                        this.log.trace((Object)("successfully received response from " + host + " (after " + (stop - start) + "ms)"));
                    }
                } else {
                    if (this.trace) {
                        this.log.debug((Object)("could not ping " + suspected_mbr + " after " + (stop - start) + "ms; " + "passing up SUSPECT event"));
                    }
                    this.suspects.remove(suspected_mbr);
                    this.passUp(new Event(9, suspected_mbr));
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error((Object)("failed pinging " + suspected_mbr), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        boolean removed = false;
        Hashtable hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                if (this.trace) {
                    this.log.trace((Object)("member " + mbr + " is not dead !"));
                }
                this.suspects.remove(mbr);
                removed = true;
            }
        }
        if (removed) {
            this.passDown(new Event(51, mbr));
            this.passUp(new Event(51, mbr));
        }
    }

    void startTimer() {
        if (this.timer == null || !this.timer.isAlive()) {
            this.timer = new Thread((Runnable)this, "VERIFY_SUSPECT.TimerThread");
            this.timer.setDaemon(true);
            this.timer.start();
        }
    }

    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            this.intf = NetworkInterface.getByInetAddress(this.bind_addr);
        }
    }

    public void stop() {
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
        this.timer = null;
    }

    public static class VerifyHeader
    extends Header
    implements Streamable {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from = null;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.type);
            out.writeObject(this.from);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = (Address)in.readObject();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }
    }
}

