/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Membership;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Util;

public class MERGE
extends Protocol
implements Runnable {
    final Vector members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    final String groupname;
    Thread hello_thread = null;
    long timeout = 5000L;
    String router_host = null;
    int router_port = 0;
    RouterStub client = null;
    boolean is_server = false;
    boolean is_coord = false;
    boolean merging = false;

    public MERGE() {
        this.groupname = null;
    }

    public String getName() {
        return "MERGE";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("router_host")) != null) {
            this.router_host = str;
            props.remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = Integer.parseInt(str);
            props.remove("router_port");
        }
        if (this.router_host != null && this.router_port != 0) {
            this.client = new RouterStub(this.router_host, this.router_port);
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        if (this.hello_thread == null) {
            this.hello_thread = new Thread((Runnable)this, "MERGE Thread");
            this.hello_thread.setDaemon(true);
            this.hello_thread.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.hello_thread != null && this.hello_thread.isAlive()) {
            tmp = this.hello_thread;
            this.hello_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hello_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof MergeHeader)) {
                    this.passUp(evt);
                    return;
                }
                MergeHeader hdr = (MergeHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        if (!this.is_server || !this.is_coord) {
                            return;
                        }
                        if (this.merging) {
                            return;
                        }
                        Address sender = msg.getSrc();
                        if (sender != null && this.members.size() >= 0) {
                            boolean contains;
                            Vector vector = this.members;
                            synchronized (vector) {
                                contains = this.members.contains(sender);
                            }
                            if (!contains && sender.compareTo(this.local_addr) < 0) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info((Object)("membership " + this.members + " does not contain " + sender + "; merging it"));
                                }
                                Vector<Address> tmp = new Vector<Address>();
                                tmp.addElement(sender);
                                this.merging = true;
                                this.passUp(new Event(14, tmp));
                            }
                        }
                        return;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("got MERGE hdr with unknown type (" + hdr.type + ')'));
                }
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 15: {
                this.passDown(evt);
                break;
            }
            case 45: {
                this.merging = false;
                this.passDown(evt);
                break;
            }
            case 6: {
                this.merging = false;
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.clear();
                    this.members.addAll(((View)evt.getArg()).getMembers());
                    if (this.members == null || this.members.size() == 0) {
                        if (this.log.isFatalEnabled()) {
                            this.log.fatal((Object)"received VIEW_CHANGE with null or empty vector");
                        }
                        System.exit(6);
                    }
                }
                this.is_coord = this.members.elementAt(0).equals(this.local_addr);
                this.passDown(evt);
                if (this.is_coord) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"start sending Hellos");
                    }
                    try {
                        this.start();
                    }
                    catch (Exception ex) {
                        if (!this.warn) break;
                        this.log.warn((Object)("exception calling start(): " + ex));
                    }
                    break;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"stop sending Hellos");
                }
                this.stop();
                break;
            }
            case 16: {
                this.passDown(evt);
                try {
                    this.start();
                    this.is_server = true;
                }
                catch (Exception ex) {
                    if (!this.warn) break;
                    this.log.warn((Object)("exception calling start(): " + ex));
                }
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                if (this.local_addr != null && evt.getArg() != null && this.local_addr.equals(evt.getArg())) {
                    this.stop();
                }
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector members_to_merge = new Vector();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        while (this.hello_thread != null) {
            Util.sleep(this.timeout);
            if (this.hello_thread == null) break;
            if (this.client == null) {
                Message hello_msg = new Message(null);
                MergeHeader hdr = new MergeHeader(1);
                hello_msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, hello_msg));
                continue;
            }
            List rsps = this.client.get(this.group_addr);
            Vector vector = this.members;
            synchronized (vector) {
                members_to_merge.removeAllElements();
                Iterator it = rsps.iterator();
                while (it.hasNext()) {
                    Object mbr = it.next();
                    if (this.members.contains(mbr)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("membership " + this.members + " does not contain " + mbr + "; merging it"));
                    }
                    members_to_merge.addElement(mbr);
                }
                if (members_to_merge.size() > 0) {
                    Membership new_membership = new Membership(members_to_merge);
                    new_membership.sort();
                    Address coord = (Address)new_membership.elementAt(0);
                    Vector<Address> tmp = new Vector<Address>();
                    tmp.addElement(coord);
                    if (coord.compareTo(this.local_addr) < 0) {
                        this.passUp(new Event(14, tmp));
                    }
                }
            }
        }
    }

    public static class MergeHeader
    extends Header {
        public static final int HELLO = 1;
        public int type = 0;

        public MergeHeader() {
        }

        public MergeHeader(int type) {
            this.type = type;
        }

        public String toString() {
            return "[MERGE: type=" + this.type2Str(this.type) + ']';
        }

        String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "HELLO";
                }
            }
            return "<unkown type (" + t + ")>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

