/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adaptjms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.adaptjms.ReceiverThread;
import org.jgroups.tests.adaptjms.Request;
import org.jgroups.tests.adaptjms.SenderThread;
import org.jgroups.util.Util;

public class JmsTester {
    private boolean sender;
    private int num_msgs;
    private int msg_size;
    private int num_senders;
    private long log_interval = 1000L;
    Connection conn;
    TopicSession session;
    TopicPublisher pub;
    Topic topic;
    int num_members;
    Object local_addr;
    MyReceiver receiver = null;
    List members = new ArrayList();

    public JmsTester(Connection conn, TopicSession session, Topic topic, TopicPublisher pub, boolean snd, int num_msgs, int msg_size, int num_members, int ns, long log_interval) {
        this.sender = snd;
        this.num_msgs = num_msgs;
        this.msg_size = msg_size;
        this.num_senders = ns;
        this.num_members = num_members;
        this.log_interval = log_interval;
        this.conn = conn;
        this.session = session;
        this.topic = topic;
        this.pub = pub;
    }

    public void initialize() throws Exception {
        this.local_addr = this.conn.getClientID();
        this.waitUntilAllMembersHaveJoined();
        Util.sleep(1000L);
        this.conn.start();
        new ReceiverThread(this.session, this.topic, this.num_msgs, this.msg_size, this.num_senders, this.log_interval).start();
        if (this.sender) {
            new SenderThread(this.session, this.pub, this.topic, this.num_msgs, this.msg_size, this.log_interval).start();
        }
    }

    void waitUntilAllMembersHaveJoined() throws Exception {
        this.discoverExistingMembers();
    }

    private void discoverExistingMembers() throws Exception {
        this.receiver = new MyReceiver();
        this.members.clear();
        this.receiver.start();
        this.receiver.discoverExistingMembers();
        this.receiver.sendMyAddress();
        this.receiver.waitUntilAllMembersHaveJoined();
    }

    class MyReceiver
    implements MessageListener {
        boolean running = true;
        TopicSubscriber sub;

        MyReceiver() {
        }

        public void start() throws JMSException {
            this.sub = JmsTester.this.session.createSubscriber(JmsTester.this.topic);
            this.sub.setMessageListener((MessageListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            if (message instanceof ObjectMessage) {
                Request req = (Request)message;
                switch (req.type) {
                    case 1: {
                        Request rsp = new Request(2, JmsTester.this.local_addr);
                        ObjectMessage msg = null;
                        try {
                            msg = JmsTester.this.session.createObjectMessage((Serializable)rsp);
                            JmsTester.this.pub.publish((Message)msg);
                        }
                        catch (JMSException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        IpAddress new_mbr = (IpAddress)req.arg;
                        if (JmsTester.this.members.contains(new_mbr)) break;
                        JmsTester.this.members.add(new_mbr);
                        System.out.println("-- discovered " + new_mbr);
                        if (JmsTester.this.members.size() < JmsTester.this.num_members) break;
                        System.out.println("-- all members have joined (" + JmsTester.this.members + ')');
                        this.running = false;
                        MyReceiver myReceiver = this;
                        synchronized (myReceiver) {
                            if (this.sub != null) {
                                try {
                                    this.sub.setMessageListener(null);
                                }
                                catch (JMSException e) {
                                    e.printStackTrace();
                                }
                            }
                            this.notifyAll();
                            break;
                        }
                    }
                    default: {
                        System.err.println("don't recognize request with type=" + req.type);
                    }
                }
            }
        }

        public void discoverExistingMembers() throws Exception {
            Request req = new Request(1, null);
            ObjectMessage msg = JmsTester.this.session.createObjectMessage((Serializable)req);
            JmsTester.this.pub.publish((Message)msg);
        }

        public void sendMyAddress() throws Exception {
            Request req = new Request(2, JmsTester.this.local_addr);
            ObjectMessage msg = JmsTester.this.session.createObjectMessage((Serializable)req);
            JmsTester.this.pub.publish((Message)msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilAllMembersHaveJoined() throws InterruptedException {
            if (JmsTester.this.members.size() < JmsTester.this.num_members) {
                MyReceiver myReceiver = JmsTester.this.receiver;
                synchronized (myReceiver) {
                    JmsTester.this.receiver.wait();
                }
            }
        }
    }
}

