/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.List;

public class STATE_TRANSFER
extends Protocol {
    Address local_addr = null;
    final Vector members = new Vector();
    long state_id = 1L;
    final List state_requesters = new List();
    Digest digest = null;
    final HashMap map = new HashMap();
    long start;
    long stop;
    static final String name = "STATE_TRANSFER";

    public String getName() {
        return name;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        return retval;
    }

    public void init() throws Exception {
        this.map.put("state_transfer", Boolean.TRUE);
        this.map.put("protocol_class", this.getClass().getName());
    }

    public void start() throws Exception {
        this.passUp(new Event(56, this.map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 16: {
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    this.members.addAll(new_members);
                    break;
                }
            }
            case 43: {
                List list = this.state_requesters;
                synchronized (list) {
                    if (this.digest != null && this.log.isWarnEnabled()) {
                        this.log.warn((Object)"GET_DIGEST_STATE_OK: existing digest is not null, overwriting it !");
                    }
                    this.digest = (Digest)evt.getArg();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("GET_DIGEST_STATE_OK: digest is " + this.digest + "\npassUp(GET_APPLSTATE)"));
                    }
                    this.passUp(new Event(17));
                }
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (!(msg.getHeader(name) instanceof StateHeader)) break;
                StateHeader hdr = (StateHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr.sender, hdr.id);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr.sender, hdr.my_digest, msg.getBuffer());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("type " + hdr.type + " not known in StateHeader"));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    this.members.addAll(new_members);
                    break;
                }
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.type != 1 && this.log.isWarnEnabled()) {
                    this.log.warn((Object)("[GET_STATE] (info=" + info + "): getting the state from " + "all members is not currently supported by pbcast.STATE_TRANSFER, will use " + "coordinator to fetch state instead"));
                }
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"GET_STATE: cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"GET_STATE: first member (no state)");
                    }
                    this.passUp(new Event(20, null));
                } else {
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(name, new StateHeader(1, this.local_addr, this.state_id++, null));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("GET_STATE: asking " + target + " for state"));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"passing down a SUSPEND_STABLE event");
                    }
                    this.passDown(new Event(65, new Long(info.timeout)));
                    this.start = System.currentTimeMillis();
                    this.passDown(new Event(1, state_req));
                }
                return;
            }
            case 18: {
                byte[] state = (byte[])evt.getArg();
                List list = this.state_requesters;
                synchronized (list) {
                    if (this.state_requesters.size() == 0) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"GET_APPLSTATE_OK: received application state, but there are no requesters !");
                        }
                        return;
                    }
                    if (this.digest == null) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"GET_APPLSTATE_OK: received application state, but there is no digest !");
                        } else {
                            this.digest = this.digest.copy();
                        }
                    }
                    Enumeration e = this.state_requesters.elements();
                    while (e.hasMoreElements()) {
                        Address requester = (Address)e.nextElement();
                        Message state_rsp = new Message(requester, null, state);
                        StateHeader hdr = new StateHeader(2, this.local_addr, 0L, this.digest);
                        state_rsp.putHeader(name, hdr);
                        this.passDown(new Event(1, state_rsp));
                    }
                    this.digest = null;
                    this.state_requesters.removeAll();
                }
                return;
            }
        }
        this.passDown(evt);
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        if (props.size() > 0) {
            System.err.println("STATE_TRANSFER.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    Address determineCoordinator() {
        Address ret = null;
        if (this.members != null && this.members.size() > 1) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (this.local_addr.equals(this.members.elementAt(i))) continue;
                return (Address)this.members.elementAt(i);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleStateReq(Object sender, long state_id) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null !");
            }
            return;
        }
        List list = this.state_requesters;
        synchronized (list) {
            if (this.state_requesters.size() > 0) {
                this.state_requesters.add(sender);
            } else {
                this.state_requesters.add(sender);
                this.digest = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"passing down GET_DIGEST_STATE");
                }
                this.passDown(new Event(42));
            }
        }
    }

    void handleStateRsp(Object sender, Digest digest, byte[] state) {
        if (digest == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("digest received from " + sender + " is null, skipping setting digest !"));
            }
        } else {
            this.passDown(new Event(41, digest));
        }
        this.stop = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"passing down a RESUME_STABLE event");
        }
        this.passDown(new Event(66));
        if (state == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("state received from " + sender + " is null, will return null state to application"));
            }
        } else {
            this.log.debug((Object)("received state, size=" + state.length + " bytes. Time=" + (this.stop - this.start) + " milliseconds"));
        }
        this.passUp(new Event(20, state));
    }

    public static class StateHeader
    extends Header {
        static final int STATE_REQ = 1;
        static final int STATE_RSP = 2;
        Address sender = null;
        long id = 0L;
        int type = 0;
        Digest my_digest = null;

        public StateHeader() {
        }

        public StateHeader(int type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public boolean equals(Object o) {
            StateHeader other = null;
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[StateHeader: type=" + StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=" + this.sender + " id=#" + this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=" + this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeInt(this.type);
            out.writeObject(this.my_digest);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readInt();
            this.my_digest = (Digest)in.readObject();
        }
    }
}

